/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.ClientOnly;
import com.brandon3055.brandonscore.client.gui.ContributorConfigGui;
import com.brandon3055.brandonscore.client.gui.HudConfigGui;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.handlers.contributor.ContributorProperties;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;

public class BCClientCommands {
    private static long lastReload = 0L;
    private static long lastLink = 0L;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"bcore_client");
        builder.then(BCClientCommands.contributor());
        builder.then(BCClientCommands.hudConfig());
        if (BrandonsCore.inDev) {
            // empty if block
        }
        dispatcher.register(builder);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> hudConfig() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"hudconfig").requires(cs -> cs.m_6761_(0))).executes(context -> {
            DelayedTask.client(10, () -> Minecraft.m_91087_().m_91152_((Screen)new HudConfigGui.Screen()));
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> contributor() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"contributor").requires(cs -> cs.m_6761_(0))).executes(context -> {
            Player player = ClientOnly.getClientPlayer();
            ContributorProperties props = ContributorHandler.getProps(player);
            if (!props.isLoadComplete()) {
                player.m_213846_((Component)Component.m_237113_((String)"Your contributor status has not yet been determined. Please wait a few seconds and try again."));
                return 0;
            }
            if (!props.isContributor()) {
                player.m_213846_((Component)Component.m_237113_((String)"This command allows Draconic Evolution contributors to configure their contributor perks.").m_130940_(ChatFormatting.GREEN));
                player.m_213846_((Component)Component.m_237113_((String)"Contributor perks are purely aesthetic features offered to those who support Draconic Evolution.").m_130940_(ChatFormatting.GREEN));
                player.m_213846_((Component)Component.m_237113_((String)"You can find more information on my patreon page: ").m_130940_(ChatFormatting.GREEN));
                MutableComponent link = Component.m_237113_((String)"www.patreon.com/brandon3055").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.patreon.com/brandon3055")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to open or copy link"))));
                player.m_213846_((Component)link.m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE}));
                player.m_213846_((Component)Component.m_237113_((String)""));
                MutableComponent notLinked = Component.m_237113_((String)"Please Click Here").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/bcore_client contributor help")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click for help"))));
                player.m_213846_((Component)Component.m_237113_((String)"Already a contributor? ").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)notLinked.m_130940_(ChatFormatting.BLUE)));
                return 0;
            }
            DelayedTask.client(10, () -> Minecraft.m_91087_().m_91152_((Screen)new ContributorConfigGui.Screen(player, props)));
            return 0;
        })).then(Commands.m_82127_((String)"help").executes(context -> {
            Player player = ClientOnly.getClientPlayer();
            player.m_213846_((Component)Component.m_237113_((String)"If you are already a contributor but you you cant access your perks there are several possible causes.").m_130940_(ChatFormatting.YELLOW));
            player.m_213846_((Component)Component.m_237113_((String)"Your contributor status might not have have been linked to your Minecraft user id. If you are a patron then you should have received a message with instructions when you signed up. If you are playing in offline mode your contributor status can not be verified. Or your client might not be able to contact the contributor API for some reason.").m_130940_(ChatFormatting.GRAY));
            MutableComponent link = Component.m_237113_((String)"DE Discord").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/e2HBEtF")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to open or copy link"))));
            player.m_213846_((Component)Component.m_237113_((String)"If you need help you can request assistance via the ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)link.m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE})));
            return 0;
        }))).then(Commands.m_82127_((String)"reload").executes(context -> {
            if (System.currentTimeMillis() - lastReload < 30000L && !BrandonsCore.inDev) {
                Player player = ClientOnly.getClientPlayer();
                player.m_213846_((Component)Component.m_237113_((String)"Please wait at least 30 seconds before running this command again").m_130940_(ChatFormatting.RED));
            } else {
                ContributorHandler.reload();
                lastReload = System.currentTimeMillis();
            }
            return 0;
        }))).then(Commands.m_82127_((String)"link").then(Commands.m_82129_((String)"link_code", (ArgumentType)StringArgumentType.string()).executes(context -> {
            Player player = ClientOnly.getClientPlayer();
            if (System.currentTimeMillis() - lastLink < 30000L && !BrandonsCore.inDev) {
                player.m_213846_((Component)Component.m_237113_((String)"Please wait at least 30 seconds before running this command again").m_130940_(ChatFormatting.RED));
            } else {
                String linkCode = StringArgumentType.getString((CommandContext)context, (String)"link_code");
                ContributorHandler.linkUser(player, linkCode, error -> {
                    if (error == -1) {
                        player.m_213846_((Component)Component.m_237113_((String)"Link Successful!").m_130940_(ChatFormatting.GREEN));
                    } else {
                        player.m_213846_((Component)Component.m_237113_((String)"An error occurred.").m_130940_(ChatFormatting.RED));
                        player.m_213846_((Component)Component.m_237113_((String)(error == 404 ? "Invalid Link Code" : "Unknown error code: " + error)).m_130940_(ChatFormatting.RED));
                    }
                });
                lastLink = System.currentTimeMillis();
            }
            return 0;
        })));
    }
}

