/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.hud;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.hud.HudManager;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;

public class HudData {
    private static Path settingsPath = Paths.get("./config/brandon3055/hud_settings.json", new String[0]);
    private static Gson gson = new Gson();
    private static int settingsDirty = 0;

    protected static void clientTick() {
        if (settingsDirty > 0 && --settingsDirty <= 0) {
            HudData.saveSettings();
        }
    }

    public static void dirtySettings() {
        settingsDirty = 600;
    }

    public static void saveIfDirty() {
        if (settingsDirty > 0) {
            settingsDirty = 0;
            HudData.saveSettings();
        }
    }

    private static void saveSettings() {
        JsonObject storage = new JsonObject();
        try (JsonWriter fileWriter = new JsonWriter((Writer)new FileWriter(settingsPath.toFile()));){
            fileWriter.setIndent("    ");
            for (ResourceLocation key : HudManager.hudElements.keySet()) {
                CompoundTag nbt = new CompoundTag();
                HudManager.hudElements.get(key).writeNBT(nbt);
                storage.addProperty(key.toString(), nbt.toString());
            }
            Streams.write((JsonElement)storage, (JsonWriter)fileWriter);
            fileWriter.flush();
        }
        catch (Throwable e) {
            BrandonsCore.LOGGER.error("An error occurred while saving hud settings to disk!");
            e.printStackTrace();
            settingsPath.toFile().delete();
        }
    }

    protected static void loadSettings() {
        if (!settingsPath.toFile().exists()) {
            HudData.saveSettings();
        }
        try (JsonReader reader = new JsonReader((Reader)new FileReader(settingsPath.toFile()));){
            JsonParser parser = new JsonParser();
            reader.setLenient(true);
            JsonObject element = (JsonObject)parser.parse(reader);
            for (Map.Entry entry : element.entrySet()) {
                ResourceLocation key = new ResourceLocation((String)entry.getKey());
                if (!HudManager.hudElements.containsKey(key)) continue;
                CompoundTag nbt = TagParser.m_129359_((String)((JsonElement)entry.getValue()).getAsString());
                HudManager.hudElements.get(key).readNBT(nbt);
            }
        }
        catch (Throwable e2) {
            BrandonsCore.LOGGER.error("An error occurred while loading hud settings from disk!");
            e2.printStackTrace();
        }
        HudManager.hudElements.values().forEach(e -> e.setChangeListener(HudData::dirtySettings));
    }
}

