/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import vazkii.botania.data.util.OverrideHolder;

public class ModelWithOverrides {
    private final ResourceLocation parent;
    private final TextureSlot[] requiredTextures;

    public ModelWithOverrides(ResourceLocation parent, TextureSlot ... requiredTextures) {
        this.parent = parent;
        this.requiredTextures = requiredTextures;
    }

    public void create(ResourceLocation modelId, TextureMapping textures, OverrideHolder overrides, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        Map textureMap = (Map)Streams.concat((Stream[])new Stream[]{Arrays.stream(this.requiredTextures), textures.m_125742_()}).collect(ImmutableMap.toImmutableMap(Function.identity(), arg_0 -> ((TextureMapping)textures).m_125756_(arg_0)));
        consumer.accept(modelId, () -> {
            JsonArray overridesJson;
            JsonObject ret = new JsonObject();
            ret.addProperty("parent", this.parent.toString());
            if (!textureMap.isEmpty()) {
                JsonObject textureJson = new JsonObject();
                textureMap.forEach((k, path) -> textureJson.addProperty(k.m_125897_(), path.toString()));
                ret.add("textures", (JsonElement)textureJson);
            }
            if ((overridesJson = overrides.toJson()) != null) {
                ret.add("overrides", (JsonElement)overridesJson);
            }
            return ret;
        });
    }
}

