/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.manasteel;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.PhantomInkable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.CustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.proxy.Proxy;

public class ManasteelArmorItem
extends ArmorItem
implements CustomDamageItem,
PhantomInkable {
    private static final String TAG_PHANTOM_INK = "phantomInk";
    public final ArmorItem.Type type;
    private static final Supplier<ItemStack[]> armorSet = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)BotaniaItems.manasteelHelm), new ItemStack((ItemLike)BotaniaItems.manasteelChest), new ItemStack((ItemLike)BotaniaItems.manasteelLegs), new ItemStack((ItemLike)BotaniaItems.manasteelBoots)});

    public ManasteelArmorItem(ArmorItem.Type type, Item.Properties props) {
        this(type, BotaniaAPI.instance().getManasteelArmorMaterial(), props);
    }

    public ManasteelArmorItem(ArmorItem.Type type, ArmorMaterial mat, Item.Properties props) {
        super(mat, type, props);
        this.type = type;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!world.f_46443_ && stack.m_41773_() > 0 && ManaItemHandler.instance().requestManaExact(stack, player, this.getManaPerDamage() * 2, true)) {
                stack.m_41721_(stack.m_41773_() - 1);
            }
        }
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return ToolCommons.damageItemIfPossible(stack, amount, entity, this.getManaPerDamage());
    }

    protected int getManaPerDamage() {
        return 70;
    }

    @NotNull
    public final String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return this.hasPhantomInk(stack) ? "botania:textures/model/armor_invisible.png" : this.getArmorTextureAfterInk(stack, slot);
    }

    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return "botania:textures/model/armor_manasteel.png";
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        TooltipHandler.addOnShift(list, () -> this.addInformationAfterShift(stack, world, list, flags));
    }

    public void addInformationAfterShift(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        ItemStack[] stacks;
        Player player = Proxy.INSTANCE.getClientPlayer();
        list.add(this.getArmorSetTitle(player));
        this.addArmorSetDescription(stack, list);
        for (ItemStack armor : stacks = this.getArmorSetStacks()) {
            MutableComponent cmp = Component.m_237113_((String)" - ").m_7220_(armor.m_41786_());
            EquipmentSlot slot = ((ArmorItem)armor.m_41720_()).m_40402_();
            cmp.m_130940_(this.hasArmorSetItem(player, slot) ? ChatFormatting.GREEN : ChatFormatting.GRAY);
            list.add((Component)cmp);
        }
        if (this.hasPhantomInk(stack)) {
            list.add((Component)Component.m_237115_((String)"botaniamisc.hasPhantomInk").m_130940_(ChatFormatting.GRAY));
        }
    }

    public ItemStack[] getArmorSetStacks() {
        return armorSet.get();
    }

    public boolean hasArmorSet(Player player) {
        return this.hasArmorSetItem(player, EquipmentSlot.HEAD) && this.hasArmorSetItem(player, EquipmentSlot.CHEST) && this.hasArmorSetItem(player, EquipmentSlot.LEGS) && this.hasArmorSetItem(player, EquipmentSlot.FEET);
    }

    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null || player.m_150109_() == null || player.m_150109_().f_35975_ == null) {
            return false;
        }
        ItemStack stack = player.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.m_150930_(BotaniaItems.manasteelHelm);
            case EquipmentSlot.CHEST -> stack.m_150930_(BotaniaItems.manasteelChest);
            case EquipmentSlot.LEGS -> stack.m_150930_(BotaniaItems.manasteelLegs);
            case EquipmentSlot.FEET -> stack.m_150930_(BotaniaItems.manasteelBoots);
            default -> false;
        };
    }

    private int getSetPiecesEquipped(Player player) {
        int pieces = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !this.hasArmorSetItem(player, slot)) continue;
            ++pieces;
        }
        return pieces;
    }

    public MutableComponent getArmorSetName() {
        return Component.m_237115_((String)"botania.armorset.manasteel.name");
    }

    private Component getArmorSetTitle(Player player) {
        MutableComponent end = this.getArmorSetName().m_130946_(" (" + this.getSetPiecesEquipped(player) + "/" + this.getArmorSetStacks().length + ")").m_130940_(ChatFormatting.GRAY);
        return Component.m_237115_((String)"botaniamisc.armorset").m_130946_(" ").m_7220_((Component)end);
    }

    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        list.add((Component)Component.m_237115_((String)"botania.armorset.manasteel.desc").m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public boolean hasPhantomInk(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_PHANTOM_INK, false);
    }

    @Override
    public void setPhantomInk(ItemStack stack, boolean ink) {
        ItemNBTHelper.setBoolean(stack, TAG_PHANTOM_INK, ink);
    }
}

