/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class VecHelper {
    public static final Vec3 ONE = new Vec3(1.0, 1.0, 1.0);

    private VecHelper() {
    }

    public static Vec3 fromEntityCenter(Entity e) {
        return new Vec3(e.m_20185_(), e.m_20186_() + (double)(e.m_20206_() / 2.0f), e.m_20189_());
    }

    public static Vec3 rotate(Vec3 v, double theta, Vec3 axis) {
        if (Mth.m_14082_((double)theta, (double)0.0)) {
            return v;
        }
        Vec3 k = axis.m_82541_();
        float cosTheta = Mth.m_14089_((float)((float)theta));
        Vec3 firstTerm = v.m_82490_((double)cosTheta);
        Vec3 secondTerm = k.m_82537_(v).m_82490_((double)Mth.m_14031_((float)((float)theta)));
        Vec3 thirdTerm = k.m_82490_(k.m_82526_(v) * (double)(1.0f - cosTheta));
        return new Vec3(firstTerm.f_82479_ + secondTerm.f_82479_ + thirdTerm.f_82479_, firstTerm.f_82480_ + secondTerm.f_82480_ + thirdTerm.f_82480_, firstTerm.f_82481_ + secondTerm.f_82481_ + thirdTerm.f_82481_);
    }

    public static AABB boxForRange(Vec3 v, double range) {
        return VecHelper.boxForRange(v, range, range, range);
    }

    public static AABB boxForRange(Vec3 v, double rangeX, double rangeY, double rangeZ) {
        return new AABB(v.f_82479_ - rangeX, v.f_82480_ - rangeY, v.f_82481_ - rangeZ, v.f_82479_ + rangeX, v.f_82480_ + rangeY, v.f_82481_ + rangeZ);
    }

    public static float toRadians(float degrees) {
        return (float)((double)(degrees / 180.0f) * Math.PI);
    }

    public static Quaternionf rotateX(float degrees) {
        return new Quaternionf().rotateX(VecHelper.toRadians(degrees));
    }

    public static Quaternionf rotateY(float degrees) {
        return new Quaternionf().rotateY(VecHelper.toRadians(degrees));
    }

    public static Quaternionf rotateZ(float degrees) {
        return new Quaternionf().rotateZ(VecHelper.toRadians(degrees));
    }
}

