/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.client.integration.emi.BotaniaEmiPlugin;
import vazkii.botania.client.integration.emi.BotaniaEmiRecipe;
import vazkii.botania.client.integration.emi.RunicAltarEmiRecipe;
import vazkii.botania.common.block.BotaniaBlocks;

public class PetalApothecaryEmiRecipe
extends BotaniaEmiRecipe {
    private static final EmiStack APOTHECARY = EmiStack.of((ItemLike)BotaniaBlocks.defaultAltar);
    private static final EmiStack WATER_BUCKET = EmiStack.of((ItemLike)Items.f_42447_);
    private static final EmiStack WATER = EmiStack.of((Fluid)Fluids.f_76193_);
    private final List<EmiIngredient> ingredients;
    private final EmiIngredient reagent;

    public PetalApothecaryEmiRecipe(PetalApothecaryRecipe recipe) {
        super(BotaniaEmiPlugin.PETAL_APOTHECARY, recipe);
        this.ingredients = recipe.m_7527_().stream().map(EmiIngredient::of).toList();
        this.reagent = EmiIngredient.of((Ingredient)recipe.getReagent());
        this.input = Stream.concat(this.ingredients.stream(), Stream.of(WATER, this.reagent)).toList();
        this.output = List.of(EmiStack.of((ItemStack)recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_)));
    }

    public int getDisplayHeight() {
        return 107;
    }

    public int getDisplayWidth() {
        return 106;
    }

    public void addWidgets(WidgetHolder widgets) {
        RunicAltarEmiRecipe.addRunicAltarWidgets(widgets, this, this.ingredients, (EmiIngredient)APOTHECARY, (EmiStack)this.output.get(0), new EmiIngredient[]{this.reagent, WATER_BUCKET});
    }
}

