/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bioforge.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.bioforge.BioforgeMod;
import net.mcreator.bioforge.procedures.GetMCProcedure;
import net.mcreator.bioforge.procedures.GetMLProcedure;
import net.mcreator.bioforge.procedures.GetMSProcedure;
import net.mcreator.bioforge.procedures.OpenBackGenesProcedure;
import net.mcreator.bioforge.procedures.OpenCuresProcedure;
import net.mcreator.bioforge.procedures.OpenDebuffEffectsGenesProcedure;
import net.mcreator.bioforge.procedures.OpenGoodMutationsGenesProcedure;
import net.mcreator.bioforge.procedures.OpenPrimarySymptomsGenesProcedure;
import net.mcreator.bioforge.procedures.OpenTransportationGenesProcedure;
import net.mcreator.bioforge.world.inventory.GeneSequencerGUI8Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GeneSequencerGUI8ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GeneSequencerGUI8ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GeneSequencerGUI8ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GeneSequencerGUI8ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GeneSequencerGUI8ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GeneSequencerGUI8ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GeneSequencerGUI8Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            GetMSProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            GetMCProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            GetMLProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            OpenPrimarySymptomsGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OpenDebuffEffectsGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            OpenCuresProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            OpenTransportationGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            OpenBackGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            OpenGoodMutationsGenesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BioforgeMod.addNetworkMessage(GeneSequencerGUI8ButtonMessage.class, GeneSequencerGUI8ButtonMessage::buffer, GeneSequencerGUI8ButtonMessage::new, GeneSequencerGUI8ButtonMessage::handler);
    }
}

