/*
 * Decompiled with CFR 0.152.
 */
package sculk.of.ixra.item;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import sculk.of.ixra.client.model.Modelwardenarmorfix;
import sculk.of.ixra.init.SculksOfArdaModItems;
import sculk.of.ixra.procedures.WardenFeelingsOnKeyPressedProcedure;

public abstract class WardenArmorItem
extends ArmorItem {
    public WardenArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 85;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{4, 8, 10, 5})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 30;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.sculk_shrieker.shriek"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)SculksOfArdaModItems.SCULK_INGOT.get())});
            }

            public String m_6082_() {
                return "warden_armor";
            }

            public float m_6651_() {
                return 4.0f;
            }

            public float m_6649_() {
                return 0.2f;
            }
        }, type, properties);
    }

    public static class Boots
    extends WardenArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties().m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new Modelwardenarmorfix<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwardenarmorfix.LAYER_LOCATION)).LeftLeg, "right_leg", new Modelwardenarmorfix<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwardenarmorfix.LAYER_LOCATION)).RightLeg, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237115_((String)"item.sculks_of_arda.warden_armor_boots.description_0"));
            list.add((Component)Component.m_237115_((String)"item.sculks_of_arda.warden_armor_boots.description_1"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "sculks_of_arda:textures/models/armor/warden_armor_fix_layer_1.png";
        }
    }

    public static class Leggings
    extends WardenArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties().m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new Modelwardenarmorfix<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwardenarmorfix.LAYER_LOCATION)).LeftLeg, "right_leg", new Modelwardenarmorfix<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwardenarmorfix.LAYER_LOCATION)).RightLeg, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237115_((String)"item.sculks_of_arda.warden_armor_leggings.description_0"));
            list.add((Component)Component.m_237115_((String)"item.sculks_of_arda.warden_armor_leggings.description_1"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "sculks_of_arda:textures/models/armor/warden_armor_fix_layer_2.png";
        }
    }

    public static class Chestplate
    extends WardenArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new Modelwardenarmorfix<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwardenarmorfix.LAYER_LOCATION)).Body, "left_arm", new Modelwardenarmorfix<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwardenarmorfix.LAYER_LOCATION)).LeftArm, "right_arm", new Modelwardenarmorfix<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwardenarmorfix.LAYER_LOCATION)).RightArm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237115_((String)"item.sculks_of_arda.warden_armor_chestplate.description_0"));
            list.add((Component)Component.m_237115_((String)"item.sculks_of_arda.warden_armor_chestplate.description_1"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "sculks_of_arda:textures/models/armor/warden_armor_fix_layer_1.png";
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                WardenFeelingsOnKeyPressedProcedure.execute((LevelAccessor)world, entity);
            }
        }
    }

    public static class Helmet
    extends WardenArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties().m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new Modelwardenarmorfix<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelwardenarmorfix.LAYER_LOCATION)).Head, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237115_((String)"item.sculks_of_arda.warden_armor_helmet.description_0"));
            list.add((Component)Component.m_237115_((String)"item.sculks_of_arda.warden_armor_helmet.description_1"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "sculks_of_arda:textures/models/armor/warden_armor_fix_layer_1.png";
        }
    }
}

