/*
 * Decompiled with CFR 0.152.
 */
package sculk.of.ixra;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sculk.of.ixra.init.SculksOfArdaModBlockEntities;
import sculk.of.ixra.init.SculksOfArdaModBlocks;
import sculk.of.ixra.init.SculksOfArdaModEntities;
import sculk.of.ixra.init.SculksOfArdaModItems;
import sculk.of.ixra.init.SculksOfArdaModMenus;
import sculk.of.ixra.init.SculksOfArdaModMobEffects;
import sculk.of.ixra.init.SculksOfArdaModParticleTypes;
import sculk.of.ixra.init.SculksOfArdaModTabs;
import sculk.of.ixra.init.SculksOfArdaModVillagerProfessions;

@Mod(value="sculks_of_arda")
public class SculksOfArdaMod {
    public static final Logger LOGGER = LogManager.getLogger(SculksOfArdaMod.class);
    public static final String MODID = "sculks_of_arda";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("sculks_of_arda", "sculks_of_arda"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public SculksOfArdaMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        SculksOfArdaModBlocks.REGISTRY.register(bus);
        SculksOfArdaModBlockEntities.REGISTRY.register(bus);
        SculksOfArdaModItems.REGISTRY.register(bus);
        SculksOfArdaModEntities.REGISTRY.register(bus);
        SculksOfArdaModTabs.REGISTRY.register(bus);
        SculksOfArdaModMobEffects.REGISTRY.register(bus);
        SculksOfArdaModParticleTypes.REGISTRY.register(bus);
        SculksOfArdaModVillagerProfessions.PROFESSIONS.register(bus);
        SculksOfArdaModMenus.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

