/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.xmod.fluxnetwork;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import org.jetbrains.annotations.Nullable;
import sonar.fluxnetworks.api.energy.FNEnergyStorage;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;

public record FluxNetworkPower(IStorageService storage, IActionSource source) implements IFNEnergyStorage
{
    public static IFNEnergyStorage of(@Nullable IStorageService storage, IActionSource source) {
        if (storage != null) {
            return new FluxNetworkPower(storage, source);
        }
        return new FNEnergyStorage(0L);
    }

    public long receiveEnergyL(long maxReceive, boolean simulate) {
        return this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), maxReceive, Actionable.ofSimulate((boolean)simulate), this.source);
    }

    public long extractEnergyL(long maxExtract, boolean simulate) {
        return this.storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), maxExtract, Actionable.ofSimulate((boolean)simulate), this.source);
    }

    public long getEnergyStoredL() {
        return this.storage.getCachedInventory().get((AEKey)FluxKey.of(EnergyType.FE));
    }

    public long getMaxEnergyStoredL() {
        long space = this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), 0x7FFFFFFFFFFFFFFEL, Actionable.SIMULATE, this.source);
        return space + this.getEnergyStoredL();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

