/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.energy;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.config.AFConfig;
import com.glodblock.github.appflux.util.AFUtil;
import com.gregtechceu.gtceu.api.capability.compat.EUToFEProvider;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import sonar.fluxnetworks.api.FluxCapabilities;

public final class EnergyHandler {
    private static final ArrayList<Pair<Capability<?>, Handler<?>>> HANDLERS = new ArrayList();
    private static final ArrayList<Predicate<Object>> FILTER = new ArrayList();
    private static final Handler<IEnergyStorage> DEFAULT = (accepter, side, storage, source) -> {
        int actuallyDrained;
        long differ;
        long drained;
        int toAdd = accepter.receiveEnergy(AFUtil.clampLong(AFConfig.getFluxAccessorIO()), true);
        if (toAdd > 0 && (drained = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), (long)toAdd, Actionable.MODULATE, source)) > 0L && (differ = drained - (long)(actuallyDrained = accepter.receiveEnergy((int)drained, false))) > 0L) {
            storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), differ, Actionable.MODULATE, source);
        }
    };

    public static <T> void addHandler(Capability<T> cap, Handler<T> handler) {
        HANDLERS.add((Pair<Capability<?>, Handler<?>>)new ImmutablePair(cap, handler));
    }

    private static boolean passFilter(Object cap) {
        for (Predicate<Object> f : FILTER) {
            if (!f.test(cap)) continue;
            return false;
        }
        return true;
    }

    public static <T> SendAction getHandler(BlockEntity te, Direction side) {
        for (Pair<Capability<?>, Handler<?>> entry : HANDLERS) {
            Object cap = AFUtil.findCapability(te, side, (Capability)entry.getLeft());
            if (cap == null || !EnergyHandler.passFilter(cap)) continue;
            return (service, source) -> ((Handler)entry.getRight()).send(cap, side, service, source);
        }
        IEnergyStorage cap = (IEnergyStorage)AFUtil.findCapability(te, side, ForgeCapabilities.ENERGY);
        if (cap != null) {
            return (service, source) -> DEFAULT.send(cap, side, service, source);
        }
        return SendAction.NOOP;
    }

    public static void chargeNetwork(@NotNull IEnergyService energy, @NotNull IStorageService storage, @NotNull IActionSource source) {
        double toAdd = Math.floor(2.147483647E9 - energy.injectPower(2.147483647E9, Actionable.SIMULATE));
        long toDrain = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), (long)PowerUnits.AE.convertTo(PowerUnits.FE, toAdd), Actionable.MODULATE, source);
        energy.injectPower((double)toDrain, Actionable.MODULATE);
    }

    static {
        if (ModList.get().isLoaded("fluxnetworks")) {
            EnergyHandler.addHandler(FluxCapabilities.FN_ENERGY_STORAGE, (accepter, side, storage, source) -> {
                long actuallyDrained;
                long differ;
                long drained;
                long toAdd = accepter.receiveEnergyL(AFConfig.getFluxAccessorIO(), true);
                if (toAdd > 0L && (drained = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), toAdd, Actionable.MODULATE, source)) > 0L && (differ = drained - (actuallyDrained = accepter.receiveEnergyL(drained, false))) > 0L) {
                    storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), differ, Actionable.MODULATE, source);
                }
            });
        }
        if (ModList.get().isLoaded("gtceu") && AFConfig.gteuSupport()) {
            FILTER.add(o -> o instanceof EUToFEProvider.GTEnergyWrapper);
            EnergyHandler.addHandler(GTCapability.CAPABILITY_ENERGY_CONTAINER, (accepter, side, storage, source) -> {
                long drained;
                long toAddEU = accepter.getEnergyCanBeInserted();
                long voltage = accepter.getInputVoltage();
                if (voltage <= 0L) {
                    return;
                }
                long toAdd = Math.min(FeCompat.toFeLong((long)toAddEU, (int)FeCompat.ratio((boolean)false)), AFConfig.getFluxAccessorIO());
                if (toAdd > 0L && (drained = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), toAdd, Actionable.MODULATE, source)) > 0L) {
                    long drainedEU = FeCompat.toEu((long)drained, (int)FeCompat.ratio((boolean)true));
                    long amp = 1L;
                    if (drainedEU <= voltage) {
                        voltage = drainedEU;
                    } else {
                        amp = Math.min(drainedEU / voltage, accepter.getInputAmperage());
                    }
                    long actuallyDrainedEU = voltage * accepter.acceptEnergyFromNetwork(side, voltage, amp);
                    long actuallyDrained = FeCompat.toFeLong((long)actuallyDrainedEU, (int)FeCompat.ratio((boolean)false));
                    long differ = drained - actuallyDrained;
                    if (differ > 0L) {
                        storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), differ, Actionable.MODULATE, source);
                    }
                }
            });
        }
    }

    public static interface SendAction {
        public static final SendAction NOOP = (a, b) -> {};

        public void send(@NotNull IStorageService var1, @NotNull IActionSource var2);
    }

    public static interface Handler<T> {
        public void send(@NotNull T var1, Direction var2, @NotNull IStorageService var3, @NotNull IActionSource var4);
    }
}

