/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.attributeslib.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.attributeslib.client.ModifierSourceType;
import dev.shadowsoffire.attributeslib.util.Comparators;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public abstract class ModifierSource<T>
implements Comparable<ModifierSource<T>> {
    protected final ModifierSourceType<T> type;
    protected final Comparator<T> comparator;
    protected final T data;

    public ModifierSource(ModifierSourceType<T> type, Comparator<T> comparator, T data) {
        this.type = type;
        this.comparator = comparator;
        this.data = data;
    }

    public abstract void render(GuiGraphics var1, Font var2, int var3, int var4);

    public ModifierSourceType<T> getType() {
        return this.type;
    }

    public final T getData() {
        return this.data;
    }

    @Override
    public int compareTo(ModifierSource<T> o) {
        return this.comparator.compare(this.getData(), o.getData());
    }

    public static class EffectModifierSource
    extends ModifierSource<MobEffectInstance> {
        public EffectModifierSource(MobEffectInstance data) {
            super(ModifierSourceType.MOB_EFFECT, Comparator.comparing(MobEffectInstance::m_19544_, Comparators.idComparator(BuiltInRegistries.f_256974_)), data);
        }

        @Override
        public void render(GuiGraphics gfx, Font font, int x, int y) {
            MobEffectTextureManager texMgr = Minecraft.m_91087_().m_91306_();
            MobEffect effect = ((MobEffectInstance)this.data).m_19544_();
            TextureAtlasSprite sprite = texMgr.m_118732_(effect);
            float scale = 0.5f;
            PoseStack stack = gfx.m_280168_();
            stack.m_85836_();
            stack.m_85841_(scale, scale, 1.0f);
            stack.m_252880_((float)x / scale, (float)y / scale, 0.0f);
            gfx.m_280159_(0, 0, 0, 18, 18, sprite);
            stack.m_85849_();
        }
    }

    public static class ItemModifierSource
    extends ModifierSource<ItemStack> {
        public ItemModifierSource(ItemStack data) {
            super(ModifierSourceType.EQUIPMENT, Comparator.comparing(LivingEntity::m_147233_).reversed().thenComparing(Comparator.comparing(ItemStack::m_41720_, Comparators.idComparator(BuiltInRegistries.f_257033_))), data);
        }

        @Override
        public void render(GuiGraphics gfx, Font font, int x, int y) {
            PoseStack pose = gfx.m_280168_();
            pose.m_85836_();
            float scale = 0.5f;
            pose.m_85841_(scale, scale, 1.0f);
            pose.m_252880_(1.0f + (float)x / scale, 1.0f + (float)y / scale, 0.0f);
            gfx.m_280203_((ItemStack)this.data, 0, 0);
            pose.m_85849_();
        }
    }
}

