/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.augmenting;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.AugmentingTableTile;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.RerollResultMessage;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.menu.BlockEntityMenu;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import dev.shadowsoffire.placebo.network.PacketDistro;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.network.simple.SimpleChannel;

public class AugmentingMenu
extends BlockEntityMenu<AugmentingTableTile> {
    public static final int UPGRADE = 0;
    public static final int REROLL = 1;
    public static final int UPGRADE_COST = 2;
    public static final int REROLL_COST = 1;
    protected final Player player;
    protected InternalItemHandler itemInv = new InternalItemHandler(1);

    public AugmentingMenu(int id, Inventory inv, BlockPos pos) {
        super((MenuType)Adventure.Menus.AUGMENTING.get(), id, inv, pos);
        this.player = inv.f_35978_;
        this.m_38897_((Slot)new PlaceboContainerMenu.UpdatingSlot(this.itemInv, 0, 16, 16, AffixHelper::hasAffixes){

            public int m_6641_() {
                return 1;
            }

            public int m_5866_(ItemStack pStack) {
                return 1;
            }
        });
        this.m_38897_((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, ((AugmentingTableTile)this.tile).inv, 0, 16, 41, stack -> stack.m_41720_() == Adventure.Items.SIGIL_OF_ENHANCEMENT.get()));
        this.addPlayerSlots(inv, 8, 140);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && AffixHelper.hasAffixes(stack), 0, 1);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && stack.m_41720_() == Adventure.Items.SIGIL_OF_ENHANCEMENT.get(), 1, 2);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9, true);
        this.registerInvShuffleRules();
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.m_150411_(pPlayer, (Container)new RecipeWrapper((IItemHandlerModifiable)this.itemInv));
    }

    public boolean m_6366_(Player player, int id) {
        int selected = id >> 1;
        ItemStack mainItem = this.getMainItem();
        if (mainItem.m_41619_()) {
            return false;
        }
        List<AffixInstance> affixes = AugmentingMenu.computeItemAffixes(mainItem);
        if (affixes.isEmpty() || selected >= affixes.size()) {
            return false;
        }
        switch (id & 1) {
            case 0: {
                AffixInstance inst = affixes.get(selected);
                if (inst.level() >= 1.0f) {
                    return false;
                }
                ItemStack sigils = this.getSigils();
                if (!this.player.m_7500_()) {
                    if (sigils.m_41613_() < 2) {
                        return false;
                    }
                    sigils.m_41774_(2);
                }
                AffixHelper.applyAffix(mainItem, inst.withNewLevel(inst.level() + 0.25f));
                ((Slot)this.f_38839_.get(0)).m_5852_(mainItem);
                player.m_9236_().m_5594_(null, this.pos, SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, player.m_9236_().f_46441_.m_188501_() * 0.25f + 1.0f);
                player.m_9236_().m_5594_(null, this.pos, SoundEvents.f_144054_, SoundSource.PLAYERS, 0.34f, player.m_9236_().f_46441_.m_188501_() * 0.2f + 0.8f);
                player.m_9236_().m_5594_(null, this.pos, SoundEvents.f_12471_, SoundSource.PLAYERS, 0.45f, player.m_9236_().f_46441_.m_188501_() * 0.75f + 0.5f);
                return true;
            }
            case 1: {
                AffixInstance inst = affixes.get(selected);
                List<DynamicHolder<? extends Affix>> alternatives = AugmentingMenu.computeAlternatives(mainItem, inst, affixes);
                if (alternatives.isEmpty()) {
                    return false;
                }
                ItemStack sigils = this.getSigils();
                if (!this.player.m_7500_()) {
                    if (sigils.m_41613_() < 1) {
                        return false;
                    }
                    sigils.m_41774_(1);
                }
                HashMap<DynamicHolder<? extends Affix>, AffixInstance> newAffixes = new HashMap<DynamicHolder<? extends Affix>, AffixInstance>(AffixHelper.getAffixes(mainItem));
                newAffixes.remove(inst.affix());
                DynamicHolder<? extends Affix> newAffix = alternatives.get(player.f_19796_.m_188503_(alternatives.size()));
                newAffixes.put(newAffix, new AffixInstance(newAffix, mainItem, inst.rarity(), player.f_19796_.m_188501_()));
                AffixHelper.setAffixes(mainItem, newAffixes);
                ((Slot)this.f_38839_.get(0)).m_5852_(mainItem);
                player.m_9236_().m_5594_(null, this.pos, SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, player.m_9236_().f_46441_.m_188501_() * 0.25f + 1.0f);
                player.m_9236_().m_5594_(null, this.pos, SoundEvents.f_144054_, SoundSource.PLAYERS, 0.34f, player.m_9236_().f_46441_.m_188501_() * 0.2f + 0.8f);
                player.m_9236_().m_5594_(null, this.pos, SoundEvents.f_12471_, SoundSource.PLAYERS, 0.45f, player.m_9236_().f_46441_.m_188501_() * 0.75f + 0.5f);
                this.m_38946_();
                PacketDistro.sendTo((SimpleChannel)Apotheosis.CHANNEL, (Object)new RerollResultMessage(newAffix), (Player)this.player);
                return true;
            }
        }
        return false;
    }

    public ItemStack getMainItem() {
        return ((Slot)this.f_38839_.get(0)).m_7993_();
    }

    public ItemStack getSigils() {
        return ((Slot)this.f_38839_.get(1)).m_7993_();
    }

    public static List<AffixInstance> computeItemAffixes(ItemStack stack) {
        Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        if (affixes.isEmpty()) {
            return Collections.emptyList();
        }
        return affixes.values().stream().sorted(Comparator.comparing(inst -> inst.affix().getId())).filter(a -> !a.affix().equals(Apoth.Affixes.DURABLE)).toList();
    }

    protected static List<DynamicHolder<? extends Affix>> computeAlternatives(ItemStack stack, AffixInstance selected, List<AffixInstance> affixes) {
        return LootController.getAvailableAffixes(stack, (LootRarity)selected.rarity().get(), affixes.stream().map(AffixInstance::affix).collect(Collectors.toSet()), ((Affix)selected.affix().get()).getType());
    }
}

