/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.configuration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yanny.ali.configuration.LootCategory;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;

public class EntityLootCategory
extends LootCategory<EntityType<?>> {
    private final List<Class<?>> classes;

    public EntityLootCategory(ResourceLocation key, Item icon, boolean hide, List<Class<?>> classes) {
        super(key, icon, LootCategory.Type.ENTITY, hide);
        this.classes = classes;
    }

    public EntityLootCategory(JsonObject object) {
        super(LootCategory.Type.ENTITY, object);
        this.classes = GsonHelper.m_13933_((JsonObject)object, (String)"classes").asList().stream().map(JsonElement::getAsString).map(className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException("Failed to resolve class " + className);
            }
        }).toList();
    }

    @Override
    protected void toJson(JsonObject object) {
        JsonArray array = new JsonArray();
        this.classes.forEach(c -> array.add(c.getName()));
        object.add("classes", (JsonElement)array);
    }

    @Override
    public boolean validate(EntityType<?> entityType) {
        return this.classes.stream().anyMatch(p -> p.isAssignableFrom(entityType.m_142225_()));
    }
}

