/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.xmod.appmek;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.capabilities.Capabilities;
import appeng.util.BlockApiCache;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import me.ramidzkh.mekae2.ae2.stack.MekanismExternalStorageStrategy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.capabilities.Capability;
import net.pedroksl.advanced_ae.common.helpers.StorageReader;

public class AppMekPlugin {
    public static StorageReader chemicalStorageReader(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        return new ChemicalStorageReaderImpl(level, fromPos, fromSide);
    }

    private static class ChemicalStorageReaderImpl
    implements StorageReader {
        private final MekanismExternalStorageStrategy strategy;
        private final BlockApiCache<MEStorage> meCache;
        private final Direction fromSide;

        ChemicalStorageReaderImpl(ServerLevel level, BlockPos fromPos, Direction fromSide) {
            this.strategy = new MekanismExternalStorageStrategy(level, fromPos, fromSide);
            this.meCache = BlockApiCache.create((Capability)Capabilities.STORAGE, (ServerLevel)level, (BlockPos)fromPos);
            this.fromSide = fromSide;
        }

        @Override
        public long getCurrentStock(AEKey what) {
            KeyCounter keys;
            if (what.getType() != MekanismKeyType.TYPE) {
                return 0L;
            }
            MEStorage meHandler = (MEStorage)this.meCache.find(this.fromSide);
            if (meHandler != null && (keys = meHandler.getAvailableStacks()).get(what) > 0L) {
                return keys.get(what);
            }
            MEStorage wrapper = this.strategy.createWrapper(false, () -> {});
            if (wrapper == null) {
                return 0L;
            }
            return Math.max(0L, wrapper.getAvailableStacks().get(what));
        }
    }
}

