/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.recipes;

import appeng.api.stacks.GenericStack;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipeSerializer;
import net.pedroksl.ae2addonlib.recipes.IngredientStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactionChamberRecipeBuilder {
    private final List<IngredientStack.Item> inputs = new ArrayList<IngredientStack.Item>();
    private IngredientStack.Fluid fluid = null;
    private final int energy;
    private final GenericStack output;

    public ReactionChamberRecipeBuilder(@NotNull GenericStack output, int energy) {
        this.output = output;
        this.energy = energy;
    }

    public static ReactionChamberRecipeBuilder react(ItemStack stack, int energy) {
        return new ReactionChamberRecipeBuilder(Objects.requireNonNull(GenericStack.fromItemStack((ItemStack)stack)), energy);
    }

    public static ReactionChamberRecipeBuilder react(ItemLike stack, int energy) {
        return ReactionChamberRecipeBuilder.react(new ItemStack(stack), energy);
    }

    public static ReactionChamberRecipeBuilder react(ItemLike stack, int count, int energy) {
        return ReactionChamberRecipeBuilder.react(new ItemStack(stack, count), energy);
    }

    public static ReactionChamberRecipeBuilder react(FluidStack stack, int energy) {
        return new ReactionChamberRecipeBuilder(Objects.requireNonNull(GenericStack.fromFluidStack((FluidStack)stack)), energy);
    }

    public static ReactionChamberRecipeBuilder react(Fluid stack, int energy) {
        return ReactionChamberRecipeBuilder.react(new FluidStack(stack, 1000), energy);
    }

    public static ReactionChamberRecipeBuilder react(Fluid stack, int count, int energy) {
        return ReactionChamberRecipeBuilder.react(new FluidStack(stack, count), energy);
    }

    public ReactionChamberRecipeBuilder fluid(FluidStack fluid) {
        this.fluid = IngredientStack.of((FluidStack)fluid);
        return this;
    }

    public ReactionChamberRecipeBuilder fluid(Fluid fluid, int amount) {
        this.fluid = IngredientStack.of((FluidStack)new FluidStack(fluid, amount));
        return this;
    }

    public ReactionChamberRecipeBuilder input(ItemStack item) {
        this.inputs.add(IngredientStack.of((ItemStack)item));
        return this;
    }

    public ReactionChamberRecipeBuilder input(ItemLike item) {
        this.inputs.add(IngredientStack.of((ItemStack)new ItemStack(item)));
        return this;
    }

    public ReactionChamberRecipeBuilder input(ItemLike item, int count) {
        this.inputs.add(IngredientStack.of((ItemStack)new ItemStack(item, count)));
        return this;
    }

    public ReactionChamberRecipeBuilder input(TagKey<Item> tag) {
        this.inputs.add(IngredientStack.of((Ingredient)Ingredient.m_204132_(tag), (int)1));
        return this;
    }

    public ReactionChamberRecipeBuilder input(TagKey<Item> tag, int count) {
        this.inputs.add(IngredientStack.of((Ingredient)Ingredient.m_204132_(tag), (int)count));
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id));
    }

    public void save(Consumer<FinishedRecipe> consumer, String id) {
        this.save(consumer, AdvancedAE.makeId(id));
    }

    class Result
    implements FinishedRecipe {
        private final ResourceLocation id;

        public Result(ResourceLocation id) {
            this.id = id;
        }

        public void m_7917_(JsonObject json) {
            JsonObject result = ((JsonElement)ReactionChamberRecipeSerializer.GENERIC_STACK_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ReactionChamberRecipeBuilder.this.output).result().get()).getAsJsonObject();
            json.add("output", result.get("output"));
            JsonArray ingredients = new JsonArray(ReactionChamberRecipeBuilder.this.inputs.size());
            for (IngredientStack.Item input : ReactionChamberRecipeBuilder.this.inputs) {
                ingredients.add(input.toJson());
            }
            json.add("input_items", (JsonElement)ingredients);
            json.add("fluid", ReactionChamberRecipeBuilder.this.fluid.toJson());
            json.addProperty("energy", (Number)ReactionChamberRecipeBuilder.this.energy);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return ReactionChamberRecipeSerializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

