/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet.quantumarmor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.pedroksl.advanced_ae.gui.QuantumArmorStyleConfigMenu;
import net.pedroksl.ae2addonlib.network.AddonPacket;

public class QuantumArmorStylePacket
extends AddonPacket {
    private final List<Integer> slots;
    private final int color;

    public QuantumArmorStylePacket(FriendlyByteBuf stream) {
        int size = stream.readInt();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            list.add(stream.readInt());
        }
        this.slots = list;
        this.color = stream.readInt();
    }

    public QuantumArmorStylePacket(List<Integer> slots, int color) {
        this.slots = slots;
        this.color = color;
    }

    public void write(FriendlyByteBuf stream) {
        stream.writeInt(this.slots.size());
        for (Integer slotIndex : this.slots) {
            stream.writeInt(slotIndex.intValue());
        }
        stream.writeInt(this.color);
    }

    public void serverPacketData(ServerPlayer serverPlayer) {
        AbstractContainerMenu abstractContainerMenu = serverPlayer.f_36096_;
        if (abstractContainerMenu instanceof QuantumArmorStyleConfigMenu) {
            QuantumArmorStyleConfigMenu menu = (QuantumArmorStyleConfigMenu)abstractContainerMenu;
            menu.updateItemColors(this.slots, this.color);
        }
    }
}

