/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet.quantumarmor;

import appeng.api.stacks.GenericStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.pedroksl.advanced_ae.gui.QuantumArmorConfigMenu;
import net.pedroksl.ae2addonlib.network.AddonPacket;

public class QuantumArmorMagnetPacket
extends AddonPacket {
    private final int currentValue;
    private final List<GenericStack> filter;
    private final boolean blacklist;

    public QuantumArmorMagnetPacket(FriendlyByteBuf stream) {
        this.currentValue = stream.readInt();
        int size = stream.readInt();
        ArrayList<GenericStack> list = new ArrayList<GenericStack>();
        for (int i = 0; i < size; ++i) {
            list.add(GenericStack.readBuffer((FriendlyByteBuf)stream));
        }
        this.filter = list;
        this.blacklist = stream.readBoolean();
    }

    public QuantumArmorMagnetPacket(int currentValue, List<GenericStack> filter, boolean blacklist) {
        this.currentValue = currentValue;
        this.filter = filter;
        this.blacklist = blacklist;
    }

    public void write(FriendlyByteBuf stream) {
        stream.writeInt(this.currentValue);
        stream.writeInt(this.filter.size());
        for (GenericStack genericStack : this.filter) {
            GenericStack.writeBuffer((GenericStack)genericStack, (FriendlyByteBuf)stream);
        }
        stream.writeBoolean(this.blacklist);
    }

    public void serverPacketData(ServerPlayer serverPlayer) {
        AbstractContainerMenu abstractContainerMenu = serverPlayer.f_36096_;
        if (abstractContainerMenu instanceof QuantumArmorConfigMenu) {
            QuantumArmorConfigMenu menu = (QuantumArmorConfigMenu)abstractContainerMenu;
            menu.openMagnetScreen(this.currentValue, this.filter, this.blacklist);
        }
    }
}

