/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.core.definitions.AEItems;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.locator.MenuLocator;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.parts.StockExportBusPart;
import net.pedroksl.ae2addonlib.api.ISetAmountMenuHost;
import net.pedroksl.ae2addonlib.gui.SetAmountMenu;

public class StockExportBusMenu
extends UpgradeableMenu<StockExportBusPart>
implements ISetAmountMenuHost {
    private static final String OPEN_AMOUNT_MENU = "open_amount_menu";

    public StockExportBusMenu(int id, Inventory ip, StockExportBusPart host) {
        this(AAEMenus.STOCK_EXPORT_BUS.get(), id, ip, host);
    }

    public StockExportBusMenu(MenuType<? extends StockExportBusMenu> menuType, int id, Inventory ip, StockExportBusPart host) {
        super(menuType, id, ip, (IUpgradeableObject)host);
        this.registerClientAction(OPEN_AMOUNT_MENU, Integer.class, this::openAmountMenu);
    }

    protected void setupConfig() {
        this.addExpandableConfigSlots((GenericStackInv)((StockExportBusPart)this.getHost()).getConfig(), 2, 9, 5);
    }

    public boolean isSlotEnabled(int idx) {
        int upgrades = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.CAPACITY_CARD);
        return upgrades > idx;
    }

    public boolean isConfigSlot(Slot slot) {
        return this.getSlots(SlotSemantics.CONFIG).contains(slot);
    }

    public void openAmountMenu(int slotIndex) {
        MenuLocator locator;
        if (this.isClientSide()) {
            this.sendClientAction(OPEN_AMOUNT_MENU, slotIndex);
            return;
        }
        Slot slot = this.m_38853_(slotIndex);
        GenericStack currentStack = GenericStack.fromItemStack((ItemStack)slot.m_7993_());
        if (currentStack != null && (locator = this.getLocator()) != null && this.isServerSide()) {
            SetAmountMenu.open((ServerPlayer)((ServerPlayer)this.getPlayer()), (MenuLocator)this.getLocator(), (GenericStack)currentStack, newStack -> this.setFilter(slot.f_40219_, GenericStack.wrapInItemStack((GenericStack)newStack)), (ISetAmountMenuHost)this, (long)slot.m_6641_());
        }
    }

    public void returnFromSetAmountMenu() {
        Player player = this.getPlayerInventory().f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuOpener.open(AAEMenus.STOCK_EXPORT_BUS.get(), (Player)serverPlayer, (MenuLocator)this.getLocator(), (boolean)true);
        }
    }
}

