/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.upgrades;

import net.minecraft.network.FriendlyByteBuf;

public class UpgradeSettings {
    public int minValue;
    public int maxValue;
    public float multiplier;
    public int defaultValue;

    public UpgradeSettings(int value) {
        this(value, value);
    }

    public UpgradeSettings(int min, int max) {
        this(min, max, 1.0f);
    }

    public UpgradeSettings(int min, int max, float multiplier) {
        this(min, max, multiplier, max);
    }

    public UpgradeSettings(int min, int max, float multiplier, int defaultValue) {
        this.minValue = min;
        this.maxValue = max;
        this.multiplier = multiplier;
        this.defaultValue = defaultValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public static UpgradeSettings fromBytes(FriendlyByteBuf stream) {
        int minValue = stream.readInt();
        int maxValue = stream.readInt();
        float multiplier = stream.readFloat();
        int defaultValue = stream.readInt();
        return new UpgradeSettings(minValue, maxValue, multiplier, defaultValue);
    }

    public void toBytes(FriendlyByteBuf data) {
        data.writeInt(this.minValue);
        data.writeInt(this.maxValue);
        data.writeFloat(this.multiplier);
        data.writeInt(this.defaultValue);
    }
}

