/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AECheckbox;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.util.inv.AppEngInternalInventory;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.api.AAESettings;
import net.pedroksl.advanced_ae.api.ShowQuantumCrafters;
import net.pedroksl.advanced_ae.client.gui.AutoCrafterContainerRecord;
import net.pedroksl.advanced_ae.client.gui.PatternSlot;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterScreen;
import net.pedroksl.advanced_ae.client.gui.widgets.AAESettingToggleButton;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.gui.QuantumCrafterTermMenu;

public class QuantumCrafterTermScreen<C extends QuantumCrafterTermMenu>
extends AEBaseScreen<C> {
    private static final int GUI_WIDTH = 195;
    private static final int GUI_TOP_AND_BOTTOM_PADDING = 54;
    private static final int GUI_PADDING_X = 8;
    private static final int GUI_PADDING_Y = 6;
    private static final int GUI_HEADER_HEIGHT = 17;
    private static final int GUI_FOOTER_HEIGHT = 97;
    private static final int COLUMNS = 9;
    private static final int PATTERN_PROVIDER_NAME_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 155;
    private static final int ROW_HEIGHT = 18;
    private static final int SLOT_SIZE = 18;
    private static final Rect2i HEADER_BBOX = new Rect2i(0, 0, 195, 17);
    private static final Rect2i ROW_TEXT_TOP_BBOX = new Rect2i(0, 17, 195, 18);
    private static final Rect2i ROW_TEXT_MIDDLE_BBOX = new Rect2i(0, 53, 195, 18);
    private static final Rect2i ROW_TEXT_BOTTOM_BBOX = new Rect2i(0, 89, 195, 18);
    private static final Rect2i ROW_INVENTORY_TOP_BBOX = new Rect2i(0, 35, 195, 18);
    private static final Rect2i ROW_INVENTORY_MIDDLE_BBOX = new Rect2i(0, 71, 195, 18);
    private static final Rect2i ROW_INVENTORY_BOTTOM_BBOX = new Rect2i(0, 107, 195, 18);
    private static final Rect2i FOOTER_BBOX = new Rect2i(0, 125, 195, 97);
    private final HashMap<Long, AutoCrafterContainerRecord> byId = new HashMap();
    private final HashMap<Long, Int2ObjectMap<Button>> configButtons = new HashMap();
    private final HashMap<Long, Int2ObjectMap<AECheckbox>> enableButtons = new HashMap();
    private final ArrayList<AutoCrafterContainerRecord> records = new ArrayList();
    private final ArrayList<Row> rows = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private final Scrollbar scrollbar;
    private final AETextField searchField;
    private final Map<ItemStack, String> patternSearchText = new WeakHashMap<ItemStack, String>();
    private int visibleRows = 0;
    private final AAESettingToggleButton<ShowQuantumCrafters> showQuantumCrafters;

    public QuantumCrafterTermScreen(C menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.scrollbar = this.widgets.addScrollBar("scrollbar");
        this.f_97726_ = 195;
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.addToLeftToolbar((Button)new SettingToggleButton(Settings.TERMINAL_STYLE, (Enum)terminalStyle, this::toggleTerminalStyle));
        this.showQuantumCrafters = AAESettingToggleButton.serverButton(AAESettings.TERMINAL_SHOW_QUANTUM_CRAFTERS, ShowQuantumCrafters.VISIBLE);
        this.addToLeftToolbar((Button)this.showQuantumCrafters);
        this.searchField = this.widgets.addTextField("search");
        this.searchField.m_94151_(str -> this.refreshList());
        this.searchField.setPlaceholder((Component)GuiText.SearchPlaceholder.text());
    }

    public void m_7856_() {
        this.visibleRows = Math.max(2, this.config.getTerminalStyle().getRows((this.f_96544_ - 17 - 97 - 54) / 18));
        this.f_97727_ = 114 + this.visibleRows * 18;
        super.m_7856_();
        this.m_264313_((GuiEventListener)this.searchField);
        this.configButtons.forEach((k, m) -> m.forEach((key, value) -> {
            this.setVisibility((AbstractButton)value, false);
            this.m_142416_((GuiEventListener)value);
        }));
        this.enableButtons.forEach((k, m) -> m.forEach((key, value) -> {
            this.setVisibility((AbstractButton)value, false);
            this.m_142416_((GuiEventListener)value);
        }));
        this.resetScrollbar();
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((QuantumCrafterTermMenu)this.f_97732_).f_38839_.removeIf(slot -> slot instanceof PatternSlot);
        this.configButtons.forEach((k, m) -> m.forEach((key, value) -> this.setVisibility((AbstractButton)value, false)));
        this.enableButtons.forEach((k, m) -> m.forEach((key, value) -> this.setVisibility((AbstractButton)value, false)));
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < this.visibleRows; ++i) {
            Button button;
            int col;
            if (scrollLevel + i >= this.rows.size()) continue;
            Row row = this.rows.get(scrollLevel + i);
            if (row instanceof ConfigRow) {
                ConfigRow configRow = (ConfigRow)row;
                Int2ObjectMap<Button> configMap = this.configButtons.get(configRow.serverId);
                for (col = 0; col < configRow.slots; ++col) {
                    button = (Button)configMap.get(col);
                    button.m_264152_(offsetX + col * 18 + 8, offsetY + (i + 1) * 18);
                }
                configMap.forEach((key, value) -> this.setVisibility((AbstractButton)value, true));
                continue;
            }
            if (row instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                for (int col2 = 0; col2 < slotsRow.slots; ++col2) {
                    PatternSlot slot2 = new PatternSlot(slotsRow.container, slotsRow.offset + col2, col2 * 18 + 8, (i + 1) * 18);
                    ((QuantumCrafterTermMenu)this.f_97732_).f_38839_.add((Object)slot2);
                    ItemStack pattern = slotsRow.container.getInventory().getStackInSlot(slotsRow.offset + col2);
                    if ((pattern.m_41619_() || PatternDetailsHelper.decodePattern((ItemStack)pattern, (Level)level) != null) && !slotsRow.container.getInvalidArray().get(slotsRow.offset + col2)) continue;
                    guiGraphics.m_280509_(slot2.f_40220_, slot2.f_40221_, slot2.f_40220_ + 16, slot2.f_40221_ + 16, 0x7FFF0000);
                }
                continue;
            }
            if (!(row instanceof EnabledRow)) continue;
            EnabledRow enabledRow = (EnabledRow)row;
            if (!this.enableButtons.containsKey(enabledRow.container.getServerId())) continue;
            Int2ObjectMap<AECheckbox> buttonMap = this.enableButtons.get(enabledRow.container.getServerId());
            for (col = 0; col < enabledRow.slots; ++col) {
                button = (AECheckbox)buttonMap.get(col);
                button.m_264152_(offsetX + col * 18 + 8 + 1, offsetY + (i + 1) * 18);
                button.setSelected(enabledRow.container.getEnabledArray().get(enabledRow.offset + col));
            }
            buttonMap.forEach((key, value) -> this.setVisibility((AbstractButton)value, true));
        }
    }

    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.searchField.m_5953_(xCoord, yCoord)) {
            this.searchField.m_94144_("");
        }
        return super.m_6375_(xCoord, yCoord, btn);
    }

    protected void m_6597_(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof PatternSlot) {
            PatternSlot machineSlot = (PatternSlot)slot;
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (!this.getPlayer().m_150110_().f_35937_) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.f_40217_, machineSlot.getMachineInv().getServerId());
                NetworkHandler.instance().sendToServer((BasePacket)p);
            }
            return;
        }
        super.m_6597_(slot, slotIdx, mouseButton, clickType);
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.blit(guiGraphics, offsetX, offsetY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = offsetY + 17;
        this.blit(guiGraphics, offsetX, currentY + this.visibleRows * 18, FOOTER_BBOX);
        for (int i = 0; i < this.visibleRows; ++i) {
            Row row;
            boolean firstLine = i == 0;
            boolean lastLine = i == this.visibleRows - 1;
            Rect2i bbox = this.selectRowBackgroundBox(false, firstLine, lastLine);
            this.blit(guiGraphics, offsetX, currentY, bbox);
            if (scrollLevel + i < this.rows.size() && (row = this.rows.get(scrollLevel + i)) instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                bbox = this.selectRowBackgroundBox(true, firstLine, lastLine);
                bbox.m_173056_(8 + 18 * slotsRow.slots - 1);
                this.blit(guiGraphics, offsetX, currentY, bbox);
            }
            currentY += 18;
        }
    }

    private Rect2i selectRowBackgroundBox(boolean isInvLine, boolean firstLine, boolean lastLine) {
        if (isInvLine) {
            if (firstLine) {
                return ROW_INVENTORY_TOP_BBOX;
            }
            if (lastLine) {
                return ROW_INVENTORY_BOTTOM_BBOX;
            }
            return ROW_INVENTORY_MIDDLE_BBOX;
        }
        if (firstLine) {
            return ROW_TEXT_TOP_BBOX;
        }
        if (lastLine) {
            return ROW_TEXT_BOTTOM_BBOX;
        }
        return ROW_TEXT_MIDDLE_BBOX;
    }

    public boolean m_5534_(char character, int key) {
        if (character == ' ' && this.searchField.m_94155_().isEmpty()) {
            return true;
        }
        return super.m_5534_(character, key);
    }

    public void clear() {
        this.byId.clear();
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postFullUpdate(long inventoryId, long sortBy, int inventorySize, Int2ObjectMap<ItemStack> slots, Int2BooleanMap enabledArray, Int2BooleanMap invalidArray) {
        AutoCrafterContainerRecord record = new AutoCrafterContainerRecord(inventoryId, inventorySize, sortBy);
        this.byId.put(inventoryId, record);
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (ItemStack)entry.getValue());
        }
        Int2BooleanArrayMap enabled = record.getEnabledArray();
        for (Int2BooleanMap.Entry entry : enabledArray.int2BooleanEntrySet()) {
            enabled.put(entry.getIntKey(), entry.getBooleanValue());
        }
        Int2BooleanArrayMap invalid = record.getInvalidArray();
        for (Int2BooleanMap.Entry entry : invalidArray.int2BooleanEntrySet()) {
            invalid.put(entry.getIntKey(), entry.getBooleanValue());
        }
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postIncrementalUpdate(long inventoryId, Int2ObjectMap<ItemStack> slots, Int2BooleanMap enabledArray, Int2BooleanMap invalidArray) {
        AutoCrafterContainerRecord record = this.byId.get(inventoryId);
        if (record == null) {
            return;
        }
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (ItemStack)entry.getValue());
        }
        Int2BooleanArrayMap enabled = record.getEnabledArray();
        for (Int2BooleanMap.Entry entry : enabledArray.int2BooleanEntrySet()) {
            enabled.put(entry.getIntKey(), entry.getBooleanValue());
        }
        Int2BooleanArrayMap invalid = record.getInvalidArray();
        for (Int2BooleanMap.Entry entry : invalidArray.int2BooleanEntrySet()) {
            invalid.put(entry.getIntKey(), entry.getBooleanValue());
        }
    }

    public void updateBeforeRender() {
        super.updateBeforeRender();
        this.showQuantumCrafters.set(((QuantumCrafterTermMenu)this.f_97732_).getShownQuantumCrafters());
    }

    private void refreshList() {
        this.records.clear();
        this.configButtons.forEach((k, m) -> m.forEach((key, value) -> this.m_169411_((GuiEventListener)value)));
        this.configButtons.clear();
        this.enableButtons.forEach((k, m) -> m.forEach((key, value) -> this.m_169411_((GuiEventListener)value)));
        this.enableButtons.clear();
        String searchFilterLowerCase = this.searchField.m_94155_().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFilterLowerCase);
        boolean rebuild = cachedSearch.isEmpty();
        for (AutoCrafterContainerRecord entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFilterLowerCase.isEmpty();
            if (!found) {
                ItemStack itemStack;
                Iterator iterator = entry.getInventory().iterator();
                while (iterator.hasNext() && !(found = this.itemStackMatchesSearchTerm(itemStack = (ItemStack)iterator.next(), searchFilterLowerCase))) {
                }
            }
            if (found) {
                this.records.add(entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.rows.clear();
        this.rows.ensureCapacity(this.getMaxRows());
        ArrayList<AutoCrafterContainerRecord> containers = new ArrayList<AutoCrafterContainerRecord>(this.records);
        Collections.sort(containers);
        for (AutoCrafterContainerRecord container : containers) {
            AppEngInternalInventory inventory = container.getInventory();
            for (int offset = 0; offset < inventory.size(); offset += 9) {
                int slots = Math.min(inventory.size() - offset, 9);
                Int2ObjectArrayMap configButtons = new Int2ObjectArrayMap();
                Int2ObjectArrayMap enabledButtons = new Int2ObjectArrayMap();
                for (int col = 0; col < 9; ++col) {
                    int index = offset + col;
                    QuantumCrafterScreen.ConfigButton cfgButton = new QuantumCrafterScreen.ConfigButton(b -> ((QuantumCrafterTermMenu)this.f_97732_).configPattern(container.getServerId(), index));
                    configButtons.put(index, (Object)((Button)this.m_142416_((GuiEventListener)cfgButton)));
                    AECheckbox enabledButton = new AECheckbox(0, 0, 12, 12, this.style, (Component)Component.m_237119_());
                    enabledButton.setChangeListener(() -> ((QuantumCrafterTermMenu)this.f_97732_).toggleEnabledPattern(container.getServerId(), index));
                    enabledButton.setRadio(true);
                    enabledButton.m_257544_(Tooltip.m_257550_((Component)AAEText.EnablePatternButton.text()));
                    enabledButtons.put(index, (Object)((AECheckbox)this.m_142416_((GuiEventListener)enabledButton)));
                }
                this.configButtons.put(container.getServerId(), (Int2ObjectMap<Button>)configButtons);
                this.enableButtons.put(container.getServerId(), (Int2ObjectMap<AECheckbox>)enabledButtons);
                this.rows.add(new ConfigRow(container.getServerId(), slots));
                this.rows.add(new SlotsRow(container, offset, slots));
                this.rows.add(new EnabledRow(container, offset, slots));
            }
        }
        this.resetScrollbar();
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(this.visibleRows * 18 - 2);
        this.scrollbar.setRange(0, this.rows.size() - this.visibleRows, 2);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm) {
        if (itemStack.m_41619_()) {
            return false;
        }
        return this.patternSearchText.computeIfAbsent(itemStack, this::getPatternSearchText).contains(searchTerm);
    }

    private String getPatternSearchText(ItemStack stack) {
        Level level = ((QuantumCrafterTermMenu)this.f_97732_).getPlayer().m_9236_();
        StringBuilder text = new StringBuilder();
        IPatternDetails pattern = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)level);
        if (pattern != null) {
            for (GenericStack output : pattern.getOutputs()) {
                output.what().getDisplayName().m_5651_(content -> {
                    text.append(content.toLowerCase());
                    return Optional.empty();
                });
                text.append('\n');
            }
        }
        return text.toString();
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
        }
        return cache;
    }

    private void reinitialize() {
        this.m_6702_().removeAll(this.f_169369_);
        this.f_169369_.clear();
        this.m_7856_();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = (TerminalStyle)btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set((Enum)next);
        this.reinitialize();
    }

    private void setVisibility(AbstractButton b, boolean visibility) {
        b.f_93624_ = visibility;
        b.f_93623_ = visibility;
    }

    private int getMaxRows() {
        return this.byId.size() * 3;
    }

    private void blit(GuiGraphics guiGraphics, int offsetX, int offsetY, Rect2i srcRect) {
        ResourceLocation texture = AppEng.makeId((String)"textures/guis/quantum_crafter_terminal.png");
        guiGraphics.m_280218_(texture, offsetX, offsetY, srcRect.m_110085_(), srcRect.m_110086_(), srcRect.m_110090_(), srcRect.m_110091_());
    }

    protected int getVisibleRows() {
        return this.visibleRows;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface Row {
    }

    record ConfigRow(long serverId, int slots) implements Row
    {
    }

    record SlotsRow(AutoCrafterContainerRecord container, int offset, int slots) implements Row
    {
    }

    record EnabledRow(AutoCrafterContainerRecord container, int offset, int slots) implements Row
    {
    }
}

