/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.util;

import com.the9grounds.aeadditions.integration.Mods;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003JI\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\t2\u0006\u0010 \u001a\u00020!J\b\u0010#\u001a\u00020$H\u0016J\u0006\u0010%\u001a\u00020&J\t\u0010'\u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/the9grounds/aeadditions/util/ChannelInfo;", "", "id", "Ljava/util/UUID;", "level", "Lnet/minecraft/world/level/Level;", "name", "", "isPrivate", "", "creator", "creatorName", "(Ljava/util/UUID;Lnet/minecraft/world/level/Level;Ljava/lang/String;ZLjava/util/UUID;Ljava/lang/String;)V", "getCreator", "()Ljava/util/UUID;", "getCreatorName", "()Ljava/lang/String;", "getId", "()Z", "getLevel", "()Lnet/minecraft/world/level/Level;", "getName", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hasAccessTo", "player", "Lnet/minecraft/server/level/ServerPlayer;", "hasAccessToDelete", "hashCode", "", "saveToNbt", "Lnet/minecraft/nbt/CompoundTag;", "toString", "Companion", "AEAdditions-1.20.1"})
public final class ChannelInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID id;
    @NotNull
    private final Level level;
    @NotNull
    private final String name;
    private final boolean isPrivate;
    @Nullable
    private final UUID creator;
    @Nullable
    private final String creatorName;

    public ChannelInfo(@NotNull UUID id, @NotNull Level level, @NotNull String name, boolean isPrivate, @Nullable UUID creator, @Nullable String creatorName) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.id = id;
        this.level = level;
        this.name = name;
        this.isPrivate = isPrivate;
        this.creator = creator;
        this.creatorName = creatorName;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean isPrivate() {
        return this.isPrivate;
    }

    @Nullable
    public final UUID getCreator() {
        return this.creator;
    }

    @Nullable
    public final String getCreatorName() {
        return this.creatorName;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ChannelInfo && Intrinsics.areEqual((Object)this.id, (Object)((ChannelInfo)other).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public final CompoundTag saveToNbt() {
        CompoundTag channelInfoTag = new CompoundTag();
        channelInfoTag.m_128379_("isPrivate", this.isPrivate);
        channelInfoTag.m_128359_("name", this.name);
        channelInfoTag.m_128359_("id", this.id.toString());
        channelInfoTag.m_128359_("playerUUID", String.valueOf(this.creator));
        channelInfoTag.m_128359_("playerName", this.creatorName);
        return channelInfoTag;
    }

    public final boolean hasAccessTo(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.isPrivate) {
            return true;
        }
        if (Mods.FTBTEAMS.isEnabled()) {
            return FTBTeamsAPI.api().getManager().arePlayersInSameTeam(this.creator, player.m_20148_());
        }
        return Intrinsics.areEqual((Object)this.creator, (Object)player.m_20148_());
    }

    public final boolean hasAccessToDelete(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (Mods.FTBTEAMS.isEnabled()) {
            return FTBTeamsAPI.api().getManager().arePlayersInSameTeam(this.creator, player.m_20148_());
        }
        return Intrinsics.areEqual((Object)this.creator, (Object)player.m_20148_());
    }

    @NotNull
    public final UUID component1() {
        return this.id;
    }

    @NotNull
    public final Level component2() {
        return this.level;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    public final boolean component4() {
        return this.isPrivate;
    }

    @Nullable
    public final UUID component5() {
        return this.creator;
    }

    @Nullable
    public final String component6() {
        return this.creatorName;
    }

    @NotNull
    public final ChannelInfo copy(@NotNull UUID id, @NotNull Level level, @NotNull String name, boolean isPrivate, @Nullable UUID creator, @Nullable String creatorName) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new ChannelInfo(id, level, name, isPrivate, creator, creatorName);
    }

    public static /* synthetic */ ChannelInfo copy$default(ChannelInfo channelInfo, UUID uUID, Level level, String string, boolean bl, UUID uUID2, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = channelInfo.id;
        }
        if ((n & 2) != 0) {
            level = channelInfo.level;
        }
        if ((n & 4) != 0) {
            string = channelInfo.name;
        }
        if ((n & 8) != 0) {
            bl = channelInfo.isPrivate;
        }
        if ((n & 0x10) != 0) {
            uUID2 = channelInfo.creator;
        }
        if ((n & 0x20) != 0) {
            string2 = channelInfo.creatorName;
        }
        return channelInfo.copy(uUID, level, string, bl, uUID2, string2);
    }

    @NotNull
    public String toString() {
        return "ChannelInfo(id=" + this.id + ", level=" + this.level + ", name=" + this.name + ", isPrivate=" + this.isPrivate + ", creator=" + this.creator + ", creatorName=" + this.creatorName + ")";
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/the9grounds/aeadditions/util/ChannelInfo$Companion;", "", "()V", "readFromNbt", "Lcom/the9grounds/aeadditions/util/ChannelInfo;", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "level", "Lnet/minecraft/world/level/Level;", "AEAdditions-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChannelInfo readFromNbt(@NotNull CompoundTag nbt, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            boolean isPrivate = nbt.m_128471_("isPrivate");
            String creatorName = null;
            creatorName = nbt.m_128461_("playerName");
            UUID creator = UUID.fromString(nbt.m_128461_("playerUUID"));
            UUID uUID = UUID.fromString(nbt.m_128461_("id"));
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(nbt.getString(\"id\"))");
            String string = nbt.m_128461_("name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nbt.getString(\"name\")");
            return new ChannelInfo(uUID, level, string, isPrivate, creator, creatorName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

