/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.sbwtracerfire.server;

import com.atsuishio.superbwarfare.api.event.ProjectileHitEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import ru.pi.sbwtracerfire.network.NetworkHandler;
import ru.pi.sbwtracerfire.network.packet.SendTracerFirePacket;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TracerFire_server {
    private static final long FIXED_ANIMATION_DURATION = 1500L;

    @SubscribeEvent
    public static void onProjectileHit(ProjectileHitEvent event) {
        if (event instanceof ProjectileHitEvent.HitEntity) {
            ProjectileHitEvent.HitEntity hitEntity = (ProjectileHitEvent.HitEntity)event;
            Entity owner = event.getOwner();
            Projectile projectile = event.getProjectile();
            Vec3 startPos = TracerFire_server.getMuzzlePosition(projectile, owner);
            Vec3 endPos = event.getHitVec();
            int color = TracerFire_server.getTracerColor(hitEntity);
            Level level = projectile.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                NetworkHandler.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)serverLevel).m_46472_()), (Object)new SendTracerFirePacket(startPos, endPos, color, 1500L, 0.06f));
            }
        } else if (event instanceof ProjectileHitEvent.HitBlock) {
            ProjectileHitEvent.HitBlock hitBlock = (ProjectileHitEvent.HitBlock)event;
            Entity owner = event.getOwner();
            Projectile projectile = event.getProjectile();
            Vec3 startPos = TracerFire_server.getMuzzlePosition(projectile, owner);
            Vec3 endPos = event.getHitVec();
            Level level = projectile.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                NetworkHandler.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)serverLevel).m_46472_()), (Object)new SendTracerFirePacket(startPos, endPos, -47872, 1500L, 0.05f));
            }
        }
    }

    private static Vec3 getMuzzlePosition(Projectile projectile, Entity owner) {
        if (owner != null) {
            return owner.m_146892_();
        }
        Vec3 motion = projectile.m_20184_().m_82541_();
        return projectile.m_20182_().m_82546_(motion.m_82490_(2.0));
    }

    private static int getTracerColor(ProjectileHitEvent.HitEntity hitEntity) {
        return -256;
    }
}

