/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.sbwtracerfire.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import ru.pi.sbwtracerfire.client.ClientPacketHandler;

public class SendTracerFirePacket {
    private final Vec3 startPos;
    private final Vec3 endPos;
    private final int color;
    private final long duration;
    private final float thickness;

    public SendTracerFirePacket(Vec3 startPos, Vec3 endPos, int color, long duration, float thickness) {
        this.startPos = startPos;
        this.endPos = endPos;
        this.color = color;
        this.duration = duration;
        this.thickness = thickness;
    }

    public SendTracerFirePacket(Vec3 startPos, Vec3 endPos, int color) {
        this(startPos, endPos, color, 2000L, 0.05f);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.startPos.f_82479_);
        buffer.writeDouble(this.startPos.f_82480_);
        buffer.writeDouble(this.startPos.f_82481_);
        buffer.writeDouble(this.endPos.f_82479_);
        buffer.writeDouble(this.endPos.f_82480_);
        buffer.writeDouble(this.endPos.f_82481_);
        buffer.writeInt(this.color);
        buffer.writeLong(this.duration);
        buffer.writeFloat(this.thickness);
    }

    public static SendTracerFirePacket decode(FriendlyByteBuf buffer) {
        Vec3 startPos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        Vec3 endPos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        int color = buffer.readInt();
        long duration = buffer.readLong();
        float thickness = buffer.readFloat();
        return new SendTracerFirePacket(startPos, endPos, color, duration, thickness);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientPacketHandler.handleTracerFire(this));
        context.get().setPacketHandled(true);
    }

    public Vec3 getStartPos() {
        return this.startPos;
    }

    public Vec3 getEndPos() {
        return this.endPos;
    }

    public int getColor() {
        return this.color;
    }

    public long getDuration() {
        return this.duration;
    }

    public float getThickness() {
        return this.thickness;
    }
}

