/*
 * Decompiled with CFR 0.152.
 */
package ru.pi.sbwtracerfire.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TracerRenderer {
    private static final List<Tracer> activeTracers = new ArrayList<Tracer>();
    private static final Random RANDOM = new Random();
    private static final float FIXED_ANIMATION_SPEED = 50.0f;

    public static void addTracer(Vec3 start, Vec3 end, int color, long duration, float thickness) {
        activeTracers.add(new Tracer(start, end, color, duration, thickness));
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        activeTracers.removeIf(Tracer::isExpired);
        if (activeTracers.isEmpty()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        poseStack.m_85836_();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        VertexConsumer vertexConsumer = bufferSource.m_6299_((RenderType)RenderType.f_110371_);
        for (Tracer tracer : activeTracers) {
            TracerRenderer.renderAnimatedTracer(poseStack, vertexConsumer, tracer);
        }
        poseStack.m_85849_();
        bufferSource.m_109912_((RenderType)RenderType.f_110371_);
    }

    private static void renderAnimatedTracer(PoseStack poseStack, VertexConsumer consumer, Tracer tracer) {
        Vec3 headPosition;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float alpha = tracer.getAlpha();
        if (alpha <= 0.01f) {
            return;
        }
        Vec3 trailStart = tracer.getCurrentStart();
        if (trailStart.m_82554_(headPosition = tracer.getCurrentEnd()) < 0.01) {
            return;
        }
        float r = (float)(tracer.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(tracer.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(tracer.color & 0xFF) / 255.0f;
        float headBrightness = 3.0f;
        float trailBrightness = 1.2f;
        float headR = Math.min(1.0f, r * headBrightness);
        float headG = Math.min(1.0f, g * headBrightness);
        float headB = Math.min(1.0f, b * headBrightness);
        float trailR = Math.min(1.0f, r * trailBrightness);
        float trailG = Math.min(1.0f, g * trailBrightness);
        float trailB = Math.min(1.0f, b * trailBrightness);
        consumer.m_252986_(matrix, (float)trailStart.f_82479_, (float)trailStart.f_82480_, (float)trailStart.f_82481_).m_85950_(trailR, trailG, trailB, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)headPosition.f_82479_, (float)headPosition.f_82480_, (float)headPosition.f_82481_).m_85950_(headR, headG, headB, alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static class Tracer {
        private final Vec3 start;
        private final Vec3 end;
        private final int color;
        private final long spawnTime;
        private final float thickness;
        private final float flickerIntensity;
        private final float totalDistance;
        private final float animationDuration;

        public Tracer(Vec3 start, Vec3 end, int color, long duration, float thickness) {
            this.start = start;
            this.end = end;
            this.color = color;
            this.spawnTime = System.currentTimeMillis();
            this.thickness = thickness;
            this.flickerIntensity = 0.1f + RANDOM.nextFloat() * 0.2f;
            this.totalDistance = (float)start.m_82554_(end);
            this.animationDuration = Math.min((float)duration, this.totalDistance / 50.0f * 1000.0f);
        }

        public boolean isExpired() {
            return (float)(System.currentTimeMillis() - this.spawnTime) > this.animationDuration;
        }

        public float getProgress() {
            return Math.min(1.0f, (float)(System.currentTimeMillis() - this.spawnTime) / this.animationDuration);
        }

        public float getAlpha() {
            float progress = this.getProgress();
            float appear = Math.min(1.0f, progress * 5.0f);
            float disappear = 1.0f - Math.max(0.0f, (progress - 0.7f) * 3.33f);
            float baseAlpha = Math.min(appear, disappear);
            float flicker = (float)Math.sin(progress * 80.0f) * this.flickerIntensity;
            return Math.max(0.0f, baseAlpha + flicker);
        }

        public Vec3 getCurrentStart() {
            float progress = this.getProgress();
            float trailLength = 0.3f / this.totalDistance;
            float trailStart = Math.max(0.0f, progress - trailLength);
            return this.start.m_165921_(this.end, (double)trailStart);
        }

        public Vec3 getCurrentEnd() {
            float progress = this.getProgress();
            return this.start.m_165921_(this.end, (double)progress);
        }
    }
}

