/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.function.BiPredicate;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockUtils {
    private BlockUtils() {
    }

    public static boolean isSideSolid(LevelReader level, BlockPos pos, Direction side) {
        return level.m_8055_(pos).m_60783_((BlockGetter)level, pos, side);
    }

    public static Level.ExplosionInteraction getExplosionInteraction() {
        return (Boolean)ConfigHandler.SERVER.mineExplosionsBreakBlocks.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE;
    }

    public static boolean hasActiveSCBlockNextTo(Level level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        return SecurityCraftAPI.getRegisteredDoorActivators().stream().anyMatch(activator -> BlockUtils.hasActiveSCBlockNextTo(level, pos, be, activator));
    }

    private static boolean hasActiveSCBlockNextTo(Level level, BlockPos pos, BlockEntity be, IDoorActivator activator) {
        for (Direction dir : Direction.values()) {
            IOwnable ownable;
            BlockEntity offsetBe;
            BlockPos offsetPos = pos.m_121945_(dir);
            BlockState offsetState = level.m_8055_(offsetPos);
            if (activator.getBlocks().contains(offsetState.m_60734_()) && activator.isPowering(level, offsetPos, offsetState, offsetBe = level.m_7702_(offsetPos), dir, 1) && (!(offsetBe instanceof IOwnable) || (ownable = (IOwnable)offsetBe).getOwner().owns((IOwnable)be))) {
                return true;
            }
            if (level.m_277185_(offsetPos, dir) != 15 || offsetState.m_60803_()) continue;
            for (Direction dirOffset : Direction.values()) {
                IOwnable ownable2;
                BlockEntity offsetBe2;
                if (dirOffset.m_122424_() == dir) continue;
                BlockPos newOffsetPos = offsetPos.m_121945_(dirOffset);
                offsetState = level.m_8055_(newOffsetPos);
                if (!activator.getBlocks().contains(offsetState.m_60734_()) || !activator.isPowering(level, newOffsetPos, offsetState, offsetBe2 = level.m_7702_(newOffsetPos), dirOffset, 2) || offsetBe2 instanceof IOwnable && !(ownable2 = (IOwnable)offsetBe2).getOwner().owns((IOwnable)be)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends BlockEntity> boolean isAllowedToExtractFromProtectedObject(Direction side, T be) {
        return BlockUtils.isAllowedToExtractFromProtectedObject(side, (IOwnable)be, be.m_58904_(), be.m_58899_());
    }

    public static boolean isAllowedToExtractFromProtectedObject(Direction side, IOwnable ownable, Level level, BlockPos pos) {
        if (side != null && level != null) {
            BlockPos offsetPos = pos.m_121945_(side);
            BlockState offsetState = level.m_8055_(offsetPos);
            for (IExtractionBlock extractionBlock : SecurityCraftAPI.getRegisteredExtractionBlocks()) {
                if (offsetState.m_60734_() != extractionBlock.getBlock()) continue;
                return extractionBlock.canExtract(ownable, level, offsetPos, offsetState);
            }
        }
        return false;
    }

    public static boolean isInsideUnownedReinforcedBlocks(Level level, Player player, Vec3 pos, float entityWidth) {
        float width = entityWidth * 0.8f;
        AABB inWallArea = AABB.m_165882_((Vec3)pos, (double)width, (double)1.0E-6, (double)width);
        return BlockPos.m_121921_((AABB)inWallArea).anyMatch(testPos -> {
            IOwnable ownable;
            BlockEntity patt4445$temp;
            BlockState wallState = level.m_8055_(testPos);
            return wallState.m_60734_() instanceof IReinforcedBlock && wallState.m_60828_((BlockGetter)level, testPos) && (!((patt4445$temp = level.m_7702_(testPos)) instanceof IOwnable) || !(ownable = (IOwnable)patt4445$temp).isOwnedBy((Entity)player)) && Shapes.m_83157_((VoxelShape)wallState.m_60812_((BlockGetter)level, testPos).m_83216_((double)testPos.m_123341_(), (double)testPos.m_123342_(), (double)testPos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)inWallArea), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public static void updateIndirectNeighbors(Level level, BlockPos pos, Block block) {
        BlockUtils.updateIndirectNeighbors(level, pos, block, Direction.values());
    }

    public static void updateIndirectNeighbors(Level level, BlockPos pos, Block block, Direction ... directions) {
        level.m_46672_(pos, block);
        for (Direction dir : directions) {
            level.m_46672_(pos.m_121945_(dir), block);
        }
    }

    public static void removeInSequence(BiPredicate<Direction, BlockState> stateMatcher, LevelAccessor level, BlockPos pos, Direction ... directions) {
        for (Direction direction : directions) {
            int i = 1;
            BlockPos modifiedPos = pos.m_5484_(direction, i);
            while (stateMatcher.test(direction, level.m_8055_(modifiedPos))) {
                level.m_7471_(modifiedPos, false);
                modifiedPos = pos.m_5484_(direction, ++i);
            }
        }
    }

    public static float getDestroyProgress(DestroyProgress destroyProgress, float destroyTimeForOwner, BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress(destroyProgress, destroyTimeForOwner, state, player, level, pos, false);
    }

    public static float getDestroyProgress(DestroyProgress destroyProgress, float destroyTimeForOwner, BlockState state, Player player, BlockGetter level, BlockPos pos, boolean allowDefault) {
        BlockEntity be;
        boolean isBlockMine = state.m_60734_() instanceof IBlockMine;
        if ((((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue() || isBlockMine) && (be = level.m_7702_(pos)) instanceof IOwnable) {
            boolean isOwned;
            IOwnable ownable = (IOwnable)be;
            if (state.f_60599_ == -1.0f && ((isOwned = ownable.isOwnedBy((Entity)player)) || isBlockMine || ((Boolean)ConfigHandler.SERVER.allowBreakingNonOwnedBlocks.get()).booleanValue() || allowDefault && ownable.getOwner().isDefaultOwner())) {
                state.f_60599_ = destroyTimeForOwner;
                float newDestroyProgress = destroyProgress.get(state, player, level, pos) / (float)(isOwned || isBlockMine ? 1.0 : (Double)ConfigHandler.SERVER.nonOwnedBreakingSlowdown.get());
                state.f_60599_ = -1.0f;
                return newDestroyProgress;
            }
        }
        return destroyProgress.get(state, player, level, pos);
    }

    @FunctionalInterface
    public static interface DestroyProgress {
        public float get(BlockState var1, Player var2, BlockGetter var3, BlockPos var4);
    }
}

