/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.CameraController;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class}, priority=1100)
public class MinecraftMixin {
    @Redirect(method={"handleKeybinds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Options;setCameraType(Lnet/minecraft/client/CameraType;)V"))
    private void securitycraft$preventCameraSwitching(Options options, CameraType newType) {
        if (!ClientHandler.isPlayerMountedOnCamera()) {
            options.m_92157_(newType);
        }
    }

    @Inject(method={"setCameraEntity"}, at={@At(value="HEAD")})
    private void securitycraft$onSetCameraEntity(Entity newCameraEntity, CallbackInfo ci) {
        if (((Boolean)ConfigHandler.CLIENT.debugCameraResetTracing.get()).booleanValue() && Minecraft.m_91087_().f_91075_ instanceof SecurityCamera && !(newCameraEntity instanceof SecurityCamera)) {
            StackTraceElement[] stacktrace = StackWalker.getInstance().walk(frames -> (StackTraceElement[])frames.skip(1L).map(StackWalker.StackFrame::toStackTraceElement).toArray(StackTraceElement[]::new));
            Exception exception = new Exception();
            long millisSinceLastMount = CameraController.getMillisSinceLastMount();
            PlayerUtils.sendMessageToPlayer((Player)Minecraft.m_91087_().f_91074_, Utils.localize(((SecurityCameraBlock)SCContent.SECURITY_CAMERA.get()).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:security_camera.camera_reset_detected", millisSinceLastMount), ChatFormatting.RED, true);
            SecurityCraft.LOGGER.warn("Detected camera entity reset {}ms after the camera was mounted. If this time interval is very short, a mod incompatibility could be at fault. See stacktrace below for potential culprits", (Object)millisSinceLastMount);
            exception.setStackTrace(stacktrace);
            exception.printStackTrace();
        }
    }
}

