/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;

public class UniversalKeyChangerItem
extends Item {
    public UniversalKeyChangerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        DisplayCaseBlockEntity displayCase;
        Player player = ctx.m_43723_();
        InteractionHand hand = ctx.m_43724_();
        Level level = ctx.m_43725_();
        InteractionResult briefcaseResult = this.handleBriefcase(level, player, hand).m_19089_();
        if (briefcaseResult != InteractionResult.PASS) {
            return briefcaseResult;
        }
        BlockPos pos = ctx.m_8083_();
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof DisplayCaseBlockEntity && (displayCase = (DisplayCaseBlockEntity)be).isOpen() && displayCase.getDisplayedStack().m_41619_()) {
            return InteractionResult.PASS;
        }
        if (be instanceof IPasscodeProtected) {
            IDisguisable db;
            if (((IOwnable)be).isOwnedBy((Entity)player) || player.m_7500_()) {
                if (!level.f_46443_) {
                    SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.CHANGE_PASSCODE, pos));
                }
                return InteractionResult.SUCCESS;
            }
            Block block = be.m_58900_().m_60734_();
            if (!(block instanceof IDisguisable) || ((BlockItem)(db = (IDisguisable)block).getDisguisedStack((BlockGetter)level, pos).m_41720_()).m_40614_() instanceof IDisguisable) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(((IOwnable)be).getOwner())), ChatFormatting.RED);
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return this.handleBriefcase(level, player, hand);
    }

    private InteractionResultHolder<ItemStack> handleBriefcase(Level level, Player player, InteractionHand hand) {
        ItemStack keyChanger = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && player.m_21206_().m_41720_() == SCContent.BRIEFCASE.get()) {
            ItemStack briefcase = player.m_21206_();
            if (BriefcaseItem.isOwnedBy(briefcase, player) || player.m_7500_()) {
                CompoundTag tag = briefcase.m_41783_();
                if (tag != null && tag.m_128441_("passcode")) {
                    if (tag.m_128441_("saltKey") && !level.f_46443_) {
                        SaltData.removeSalt(tag.m_128342_("saltKey"));
                    }
                    PasscodeUtils.filterPasscodeAndSaltFromTag(tag);
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.passcodeReset", new Object[0]), ChatFormatting.GREEN);
                    return InteractionResultHolder.m_19090_((Object)keyChanger);
                }
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.noPasscode", new Object[0]), ChatFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.notOwned", new Object[0]), ChatFormatting.RED);
            }
            return InteractionResultHolder.m_19096_((Object)keyChanger);
        }
        return InteractionResultHolder.m_19098_((Object)keyChanger);
    }
}

