/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.inventory.BlockReinforcerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkHooks;

public class UniversalBlockReinforcerItem
extends Item {
    public UniversalBlockReinforcerItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                BlockState state = source.m_6414_();
                if (state.m_60713_((Block)SCContent.REINFORCED_DISPENSER.get())) {
                    ServerLevel level = source.m_7727_();
                    BlockPos modifyPos = source.m_7961_().m_121945_((Direction)state.m_61143_((Property)DispenserBlock.f_52659_));
                    BlockState modifyState = level.m_8055_(modifyPos);
                    this.m_123573_(UniversalBlockReinforcerItem.convertBlock(modifyState, (Level)level, stack, modifyPos, null, ((IOwnable)source.m_8118_()).getOwner()));
                    if (this.m_123570_() && !level.f_46443_ && stack.m_220157_(1, level.m_213780_(), null)) {
                        stack.m_41764_(0);
                    }
                    return stack;
                }
                return this.defaultDispenseItemBehavior.m_6115_(source, stack);
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        final ItemStack heldItem = player.m_21120_(hand);
        if (!level.f_46443_) {
            UniversalBlockReinforcerItem.maybeRemoveMending(heldItem);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                    return new BlockReinforcerMenu(windowId, inv, UniversalBlockReinforcerItem.this == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get());
                }

                public Component m_5446_() {
                    return heldItem.m_41786_();
                }
            }, data -> data.writeBoolean(this == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get()));
        }
        return InteractionResultHolder.m_19096_((Object)heldItem);
    }

    public static boolean convertBlock(BlockState state, Level level, ItemStack stack, BlockPos pos, Player player) {
        if (!player.m_7500_() && level.m_7966_(player, pos)) {
            boolean result = UniversalBlockReinforcerItem.convertBlock(state, level, stack, pos, player, new Owner(player));
            if (result && !level.f_46443_) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
            }
            return result;
        }
        return false;
    }

    public static boolean convertBlock(BlockState state, Level level, ItemStack stack, BlockPos pos, Player player, Owner owner) {
        boolean isReinforcing = UniversalBlockReinforcerItem.isReinforcing(stack);
        Block block = state.m_60734_();
        Block convertedBlock = (isReinforcing ? IReinforcedBlock.VANILLA_TO_SECURITYCRAFT : IReinforcedBlock.SECURITYCRAFT_TO_VANILLA).get(block);
        BlockState convertedState = null;
        if (isReinforcing && convertedBlock instanceof IReinforcedBlock) {
            IReinforcedBlock rb = (IReinforcedBlock)convertedBlock;
            convertedState = rb.convertToReinforced(level, pos, state);
        } else if (!isReinforcing && block instanceof IReinforcedBlock) {
            IReinforcedBlock rb = (IReinforcedBlock)block;
            convertedState = rb.convertToVanilla(level, pos, state);
        }
        if (convertedState != null) {
            BlockEntity be = level.m_7702_(pos);
            CompoundTag tag = null;
            if (be instanceof IOwnable) {
                IOwnable ownable = (IOwnable)be;
                if (player != null && !ownable.isOwnedBy((Entity)player) || !ownable.isOwnedBy(owner)) {
                    return false;
                }
            }
            if (!level.f_46443_) {
                if (be != null) {
                    tag = be.m_187482_();
                    if (be instanceof IModuleInventory) {
                        IModuleInventory inv = (IModuleInventory)be;
                        inv.dropAllModules();
                    }
                    if (be instanceof Container) {
                        Container container = (Container)be;
                        container.m_6211_();
                    } else if (be instanceof LecternBlockEntity) {
                        LecternBlockEntity lectern = (LecternBlockEntity)be;
                        lectern.m_6211_();
                    }
                }
                level.m_46597_(pos, convertedState);
                be = level.m_7702_(pos);
                if (be != null) {
                    if (tag != null) {
                        be.m_142466_(tag);
                    }
                    if (isReinforcing) {
                        ((IOwnable)be).setOwner(owner.getUUID(), owner.getName());
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isReinforcing(ItemStack stack) {
        return stack.m_150930_((Item)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get()) || !stack.m_41784_().m_128471_("is_unreinforcing");
    }

    public static void maybeRemoveMending(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (enchantments.containsKey(Enchantments.f_44962_)) {
            enchantments.remove(Enchantments.f_44962_);
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)stack);
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return !EnchantmentHelper.m_44831_((ItemStack)book).containsKey(Enchantments.f_44962_);
    }
}

