/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.ReinforcedLecternBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public class ReinforcedLecternBlock
extends LecternBlock
implements IReinforcedBlock {
    private final float destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();

    public ReinforcedLecternBlock(BlockBehaviour.Properties properties) {
        super(OwnableBlock.withReinforcedDestroyTime(properties));
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.m_5880_(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)ConfigHandler.SERVER.alwaysDrop.get() != false || super.canHarvestBlock(state, level, pos, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ReinforcedLecternBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ReinforcedLecternBlockEntity && ((be = (ReinforcedLecternBlockEntity)blockEntity).isOwnedBy((Entity)player) || be.isAllowed((Entity)player))) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof ReinforcedLecternBlockEntity) {
            ReinforcedLecternBlockEntity be = (ReinforcedLecternBlockEntity)blockEntity;
            if (isMoving) {
                be.m_6211_();
            }
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_54484_(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ReinforcedLecternBlockEntity) {
            ReinforcedLecternBlockEntity be = (ReinforcedLecternBlockEntity)blockEntity;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)be, (BlockPos)pos);
            player.m_36220_(Stats.f_12974_);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ReinforcedLecternBlockEntity(pos, state);
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.f_50624_;
    }
}

