/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class OwnableBlock
extends BaseEntityBlock {
    private static float destroyTimeTempStorage = -1.0f;
    protected final float destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();

    public OwnableBlock(BlockBehaviour.Properties properties) {
        super(OwnableBlock.withReinforcedDestroyTime(properties));
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.m_5880_(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public float defaultDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return super.m_5880_(state, player, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)ConfigHandler.SERVER.alwaysDrop.get() != false || super.canHarvestBlock(state, level, pos, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (placer instanceof Player) {
            Player player = (Player)placer;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof INameSetter) {
            INameSetter nameable = (INameSetter)blockEntity;
            nameable.setCustomName(stack.m_41786_());
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(pos, state);
    }

    public static BlockBehaviour.Properties withReinforcedDestroyTime(BlockBehaviour.Properties properties) {
        destroyTimeTempStorage = properties.f_60888_;
        return properties.m_155954_(-1.0f);
    }

    public static float getStoredDestroyTime() {
        float storedDestroyTime = destroyTimeTempStorage;
        destroyTimeTempStorage = -1.0f;
        return storedDestroyTime;
    }
}

