/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.inventory.SingleLensMenu;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SecurityCameraBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity,
IEMPAffectedBE,
MenuProvider,
ContainerListener,
SingleLensMenu.SingleLensContainer {
    private static final Map<ServerPlayer, Set<SecurityCameraBlockEntity>> RECENTLY_UNVIEWED_CAMERAS = new HashMap<ServerPlayer, Set<SecurityCameraBlockEntity>>();
    private static final Map<ResourceKey<Level>, Set<Long>> FORCE_LOADED_CAMERA_CHUNKS = new HashMap<ResourceKey<Level>, Set<Long>>();
    private static int forceLoadingCounter = 0;
    private double cameraRotation = 0.0;
    private double oCameraRotation = 0.0;
    private boolean addToRotation = SecurityCraft.RANDOM.nextBoolean();
    private final Set<Long> chunkForceLoadQueue = new HashSet<Long>();
    private Map<UUID, ChunkTrackingView> cameraFeedChunks = new HashMap<UUID, ChunkTrackingView>();
    private Map<UUID, Set<Long>> linkedFrames = new HashMap<UUID, Set<Long>>();
    private Set<UUID> playersRequestingChunks = new HashSet<UUID>();
    private int maxChunkLoadingRadius = 0;
    private boolean down = false;
    private boolean initialized = false;
    private int playersViewing = 0;
    private boolean shutDown = false;
    private float initialXRotation;
    private float initialYRotation;
    private float initialZoom = 1.0f;
    private Option.DoubleOption rotationSpeedOption = new Option.DoubleOption("rotationSpeed", 0.018, 0.01, 0.025, 0.001);
    private Option.DoubleOption movementSpeedOption = new Option.DoubleOption("movementSpeed", 2.0, 0.0, 20.0, 0.1);
    private Option.BooleanOption shouldRotateOption = new Option.BooleanOption("shouldRotate", true);
    private Option.DoubleOption customRotationOption = new Option.DoubleOption("customRotation", this.getCameraRotation(), 1.55, -1.55, (Double)this.rotationSpeedOption.get());
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IntOption opacity = new Option.IntOption("opacity", 100, 0, 255, 1);
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private LazyOptional<IItemHandler> lensHandler;
    private LensContainer lens = new LensContainer(1);

    public SecurityCameraBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get(), pos, state);
        this.lens.m_19164_(this);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.initialized) {
            Direction facing = (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING);
            this.initialized = true;
            boolean bl = this.down = facing == Direction.DOWN;
            if (!this.isModuleEnabled(ModuleType.SMART)) {
                this.setDefaultViewingDirection(facing, this.initialZoom);
            }
        }
        if (!level.f_46443_ && !this.chunkForceLoadQueue.isEmpty()) {
            HashSet<Long> queueCopy = new HashSet<Long>(this.chunkForceLoadQueue);
            for (Long chunkPosLong : queueCopy) {
                if (forceLoadingCounter > 16) break;
                Set forceLoadedChunksInDimension = FORCE_LOADED_CAMERA_CHUNKS.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), d -> new HashSet());
                ChunkPos chunkPos = new ChunkPos(chunkPosLong.longValue());
                if (!forceLoadedChunksInDimension.contains(chunkPosLong)) {
                    ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)level), (String)"securitycraft", (BlockPos)this.f_58858_, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)false);
                    forceLoadedChunksInDimension.add(chunkPosLong);
                    ++forceLoadingCounter;
                }
                this.chunkForceLoadQueue.remove(chunkPosLong);
            }
        }
        this.oCameraRotation = this.getCameraRotation();
        if (!this.shutDown && !((Boolean)this.disabled.get()).booleanValue()) {
            if (!((Boolean)this.shouldRotateOption.get()).booleanValue()) {
                GlobalPos cameraPos;
                this.cameraRotation = (Double)this.customRotationOption.get();
                if (level.f_46443_ && this.cameraRotation != this.oCameraRotation && FrameFeedHandler.hasFeed(cameraPos = GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos))) {
                    FrameFeedHandler.getFeed(cameraPos).requestFrustumUpdate();
                }
                return;
            }
            if (this.down) {
                this.cameraRotation = this.getCameraRotation() + (Double)this.rotationSpeedOption.get();
                if (this.oCameraRotation >= 6.2831854820251465) {
                    this.cameraRotation %= 6.2831854820251465;
                    this.oCameraRotation %= 6.2831854820251465;
                }
            } else {
                if (this.addToRotation && this.getCameraRotation() <= 1.5707963705062866) {
                    this.cameraRotation = this.getCameraRotation() + (Double)this.rotationSpeedOption.get();
                } else {
                    this.addToRotation = false;
                }
                if (!this.addToRotation && this.getCameraRotation() >= -1.5707963705062866) {
                    this.cameraRotation = this.getCameraRotation() - (Double)this.rotationSpeedOption.get();
                } else {
                    this.addToRotation = true;
                }
            }
            if (!level.f_46443_) {
                level.m_7260_(pos, state, state, 2);
            }
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.unlinkAllFrames();
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        this.unlinkAllFrames();
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128347_("camera_rotation", this.cameraRotation);
        tag.m_128379_("add_to_rotation", this.addToRotation);
        tag.m_128379_("shutDown", this.shutDown);
        tag.m_128365_("lens", (Tag)this.lens.m_7927_());
        tag.m_128350_("initial_x_rotation", this.initialXRotation);
        tag.m_128350_("initial_y_rotation", this.initialYRotation);
        tag.m_128350_("initial_zoom", this.initialZoom);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("camera_rotation")) {
            this.cameraRotation = tag.m_128459_("camera_rotation");
            this.addToRotation = tag.m_128471_("add_to_rotation");
        }
        this.shutDown = tag.m_128471_("shutDown");
        this.lens.m_7797_(tag.m_128437_("lens", 10));
        this.initialXRotation = tag.m_128457_("initial_x_rotation");
        this.initialYRotation = tag.m_128457_("initial_y_rotation");
        if (tag.m_128441_("initial_zoom")) {
            this.initialZoom = tag.m_128457_("initial_zoom");
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return BlockUtils.isAllowedToExtractFromProtectedObject(side, this) ? this.getNormalHandler().cast() : this.getInsertOnlyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        if (this.insertOnlyHandler != null) {
            this.insertOnlyHandler.invalidate();
        }
        if (this.lensHandler != null) {
            this.lensHandler.invalidate();
        }
        super.invalidateCaps();
    }

    public void reviveCaps() {
        this.insertOnlyHandler = null;
        this.lensHandler = null;
        super.reviveCaps();
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((Container)this.lens));
        }
        return this.insertOnlyHandler;
    }

    private LazyOptional<IItemHandler> getNormalHandler() {
        if (this.lensHandler == null) {
            this.lensHandler = LazyOptional.of(() -> new InvWrapper((Container)this.lens));
        }
        return this.lensHandler;
    }

    public void m_5757_(Container container) {
        if (this.f_58857_ == null) {
            return;
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new SingleLensMenu(id, this.f_58857_, this.f_58858_, inventory);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    @Override
    public Container getLensContainer() {
        return this.lens;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.rotationSpeedOption, this.shouldRotateOption, this.customRotationOption, this.disabled, this.opacity, this.movementSpeedOption};
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        } else if (module == ModuleType.SMART) {
            this.setDefaultViewingDirection((Direction)this.m_58900_().m_61143_((Property)SecurityCameraBlock.FACING), this.initialZoom);
        }
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option.getName().equals("disabled") && !this.f_58857_.f_46443_ && ((Boolean)((Option.BooleanOption)option).get()).booleanValue()) {
            for (ServerPlayer player : ((ServerLevel)this.f_58857_).m_6907_()) {
                SecurityCamera camera;
                Entity entity = player.m_8954_();
                if (!(entity instanceof SecurityCamera) || !(camera = (SecurityCamera)entity).m_20183_().equals((Object)this.f_58858_)) continue;
                camera.stopViewing(player);
            }
        }
        super.onOptionChanged(option);
    }

    @Override
    public void shutDown() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        IEMPAffectedBE.super.shutDown();
        if (state.m_60734_() == SCContent.SECURITY_CAMERA.get() && ((Boolean)state.m_61143_((Property)SecurityCameraBlock.POWERED)).booleanValue()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    public void startViewing() {
        if (this.playersViewing++ == 0) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecurityCameraBlock.BEING_VIEWED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void stopViewing() {
        if (--this.playersViewing == 0) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecurityCameraBlock.BEING_VIEWED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public double getCameraRotation() {
        return this.cameraRotation;
    }

    public double getOriginalCameraRotation() {
        return this.oCameraRotation;
    }

    public boolean isDown() {
        return this.down;
    }

    public void linkFrameForPlayer(ServerPlayer player, BlockPos framePos, int chunkLoadingDistance) {
        Set playerViewedFrames = this.linkedFrames.computeIfAbsent(player.m_20148_(), uuid -> new HashSet());
        BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.track(this);
        this.requestChunkSending(player, chunkLoadingDistance);
        if (chunkLoadingDistance > this.maxChunkLoadingRadius) {
            Set forceLoadedChunksInDimension = FORCE_LOADED_CAMERA_CHUNKS.computeIfAbsent((ResourceKey<Level>)this.f_58857_.m_46472_(), d -> new HashSet());
            int frameFeedForceloadingLimit = (Integer)ConfigHandler.SERVER.frameFeedForceloadingLimit.get();
            if (frameFeedForceloadingLimit >= 0 && frameFeedForceloadingLimit <= forceLoadedChunksInDimension.size()) {
                PlayerUtils.sendMessageToPlayer((Player)player, Utils.localize(((FrameBlock)((Object)SCContent.FRAME.get())).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:frame.forceloadingLimitReached", new Object[0]), ChatFormatting.RED);
            } else {
                ChunkPos cameraChunkPos = new ChunkPos(this.f_58858_);
                Long cameraChunkPosLong = cameraChunkPos.m_45588_();
                if (!forceLoadedChunksInDimension.contains(cameraChunkPosLong)) {
                    ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"securitycraft", (BlockPos)this.f_58858_, (int)cameraChunkPos.f_45578_, (int)cameraChunkPos.f_45579_, (boolean)true, (boolean)false);
                    this.chunkForceLoadQueue.add(cameraChunkPosLong);
                }
                for (int x = cameraChunkPos.f_45578_ - chunkLoadingDistance; x <= cameraChunkPos.f_45578_ + chunkLoadingDistance; ++x) {
                    for (int z = cameraChunkPos.f_45579_ - chunkLoadingDistance; z <= cameraChunkPos.f_45579_ + chunkLoadingDistance; ++z) {
                        Long forceLoadingPos = ChunkPos.m_45589_((int)x, (int)z);
                        if (forceLoadedChunksInDimension.contains(forceLoadingPos)) continue;
                        this.chunkForceLoadQueue.add(forceLoadingPos);
                    }
                }
                this.maxChunkLoadingRadius = chunkLoadingDistance;
            }
        }
        playerViewedFrames.add(framePos.m_121878_());
    }

    public void unlinkFrameForPlayer(UUID playerUUID, BlockPos framePos) {
        if (this.linkedFrames.containsKey(playerUUID)) {
            Set<Long> linkedFramesPerPlayer = this.linkedFrames.get(playerUUID);
            if (framePos != null) {
                linkedFramesPerPlayer.remove(framePos.m_121878_());
            }
            if (framePos == null || linkedFramesPerPlayer.isEmpty()) {
                this.linkedFrames.remove(playerUUID);
            }
            if (this.linkedFrames.isEmpty()) {
                Set forceLoadedChunksInDimension = FORCE_LOADED_CAMERA_CHUNKS.computeIfAbsent((ResourceKey<Level>)this.f_58857_.m_46472_(), d -> new HashSet());
                SectionPos cameraChunkPos = SectionPos.m_123199_((BlockPos)this.f_58858_);
                SecurityCameraBlockEntity.addRecentlyUnviewedCamera(this);
                BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.stopTracking(this);
                for (int x = cameraChunkPos.m_123341_() - this.maxChunkLoadingRadius; x <= cameraChunkPos.m_123341_() + this.maxChunkLoadingRadius; ++x) {
                    for (int z = cameraChunkPos.m_123343_() - this.maxChunkLoadingRadius; z <= cameraChunkPos.m_123343_() + this.maxChunkLoadingRadius; ++z) {
                        ChunkPos chunkPos = new ChunkPos(x, z);
                        Long chunkPosLong = chunkPos.m_45588_();
                        if (!forceLoadedChunksInDimension.contains(chunkPosLong) || !BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getBlockEntitiesWithCondition(this.f_58857_, be -> be.shouldKeepChunkForceloaded(chunkPos)).isEmpty()) continue;
                        ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"securitycraft", (BlockPos)this.f_58858_, (int)x, (int)z, (boolean)false, (boolean)false);
                        forceLoadedChunksInDimension.remove(chunkPosLong);
                    }
                }
                this.maxChunkLoadingRadius = 0;
            }
        }
    }

    public void unlinkFrameForAllPlayers(BlockPos framePos) {
        for (UUID player : new HashSet<UUID>(this.linkedFrames.keySet())) {
            this.unlinkFrameForPlayer(player, framePos);
        }
    }

    public void unlinkAllFrames() {
        for (UUID player : new HashSet<UUID>(this.linkedFrames.keySet())) {
            this.unlinkFrameForPlayer(player, null);
        }
        if (this.f_58857_.f_46443_) {
            FrameFeedHandler.removeAllFrameLinks(GlobalPos.m_122643_((ResourceKey)this.f_58857_.m_46472_(), (BlockPos)this.f_58858_));
        }
    }

    public boolean hasPlayerFrameLink(Player player) {
        return this.linkedFrames.containsKey(player.m_20148_());
    }

    public boolean isFrameLinked(Player player, BlockPos framePos) {
        return this.hasPlayerFrameLink(player) && this.linkedFrames.get(player.m_20148_()).contains(framePos.m_121878_());
    }

    public void requestChunkSending(ServerPlayer player, int chunkLoadingDistance) {
        this.setChunkLoadingDistance(player, chunkLoadingDistance);
        this.playersRequestingChunks.add(player.m_20148_());
    }

    public ChunkTrackingView getCameraFeedChunks(ServerPlayer player) {
        return this.cameraFeedChunks.get(player.m_20148_());
    }

    public void clearCameraFeedChunks(ServerPlayer player) {
        this.cameraFeedChunks.remove(player.m_20148_());
    }

    public void setChunkLoadingDistance(ServerPlayer player, int chunkLoadingDistance) {
        this.cameraFeedChunks.put(player.m_20148_(), new ChunkTrackingView(new ChunkPos(this.f_58858_), chunkLoadingDistance));
    }

    public boolean shouldKeepChunkTracked(ServerPlayer player, int chunkX, int chunkZ) {
        UUID uuid = player.m_20148_();
        return this.cameraFeedChunks.containsKey(uuid) && this.cameraFeedChunks.get(uuid).contains(chunkX, chunkZ);
    }

    public boolean shouldSendChunksToPlayer(ServerPlayer player) {
        return this.playersRequestingChunks.remove(player.m_20148_());
    }

    public boolean shouldKeepChunkForceloaded(ChunkPos chunkPos) {
        ChunkPos cameraPos = new ChunkPos(this.f_58858_);
        return chunkPos.f_45578_ >= cameraPos.f_45578_ - this.maxChunkLoadingRadius && chunkPos.f_45578_ <= cameraPos.f_45578_ + this.maxChunkLoadingRadius && chunkPos.f_45579_ >= cameraPos.f_45579_ - this.maxChunkLoadingRadius && chunkPos.f_45579_ <= cameraPos.f_45579_ + this.maxChunkLoadingRadius;
    }

    public static void addRecentlyUnviewedCamera(SecurityCameraBlockEntity camera) {
        for (ServerPlayer player : camera.f_58857_.m_7654_().m_6846_().m_11314_()) {
            Set unviewingCameras = RECENTLY_UNVIEWED_CAMERAS.computeIfAbsent(player, p -> new HashSet());
            unviewingCameras.add(camera);
        }
    }

    public static boolean hasRecentlyUnviewedCameras(ServerPlayer player) {
        return RECENTLY_UNVIEWED_CAMERAS.containsKey(player);
    }

    public static Set<SecurityCameraBlockEntity> fetchRecentlyUnviewedCameras(ServerPlayer player) {
        return RECENTLY_UNVIEWED_CAMERAS.remove(player);
    }

    public static void resetForceLoadingCounter() {
        forceLoadingCounter = 0;
    }

    public int getOpacity() {
        return (Integer)this.opacity.get();
    }

    public double getMovementSpeed() {
        return (Double)this.movementSpeedOption.get();
    }

    public boolean shouldRotate() {
        return (Boolean)this.shouldRotateOption.get();
    }

    public float getDefaultXRotation() {
        return this.down ? 75.0f : 30.0f;
    }

    public float getDefaultYRotation(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.EAST -> 270.0f;
            case Direction.DOWN, Direction.UP -> 0.0f;
        };
    }

    public void setDefaultViewingDirection(Direction facing, float zoom) {
        this.setDefaultViewingDirection(this.getDefaultXRotation(), this.getDefaultYRotation(facing), zoom);
    }

    public void setDefaultViewingDirection(float initialXRotation, float initialYRotation, float initialZoom) {
        this.initialXRotation = initialXRotation;
        this.initialYRotation = initialYRotation;
        this.initialZoom = initialZoom;
        this.m_6596_();
    }

    public float getInitialXRotation() {
        return this.initialXRotation;
    }

    public float getInitialYRotation() {
        return this.initialYRotation;
    }

    public float getInitialZoom() {
        return this.initialZoom;
    }

    public record ChunkTrackingView(ChunkPos center, int viewDistance) {
        public boolean contains(int x, int z) {
            return Utils.isInViewDistance(this.center.f_45578_, this.center.f_45579_, this.viewDistance, x, z);
        }
    }
}

