/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPistonBaseBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPistonHeadBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMath;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReinforcedPistonMovingBlockEntity
extends BlockEntity
implements IOwnable {
    private BlockState movedState;
    private CompoundTag movedBlockEntityTag;
    private Direction direction;
    private boolean extending;
    private boolean isSourcePiston;
    private static final ThreadLocal<Direction> NOCLIP = ThreadLocal.withInitial(() -> null);
    private float progress;
    private float lastProgress;
    private long lastTicked;
    private int deathTicks;
    private Owner owner = new Owner();

    public ReinforcedPistonMovingBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.REINFORCED_PISTON_BLOCK_ENTITY.get(), pos, state);
    }

    public ReinforcedPistonMovingBlockEntity(BlockPos pos, BlockState state, BlockState movedState, CompoundTag tag, Direction direction, boolean extending, boolean shouldHeadBeRendered) {
        this(pos, state);
        this.movedState = movedState;
        this.movedBlockEntityTag = tag;
        this.direction = direction;
        this.extending = extending;
        this.isSourcePiston = shouldHeadBeRendered;
        this.owner = Owner.fromCompound(tag);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean isExtending() {
        return this.extending;
    }

    public Direction getFacing() {
        return this.direction;
    }

    public boolean isSourcePiston() {
        return this.isSourcePiston;
    }

    public float getProgress(float ticks) {
        if (ticks > 1.0f) {
            ticks = 1.0f;
        }
        return Mth.m_14179_((float)ticks, (float)this.lastProgress, (float)this.progress);
    }

    public float getOffsetX(float ticks) {
        return (float)this.direction.m_122429_() * this.getExtendedProgress(this.getProgress(ticks));
    }

    public float getOffsetY(float ticks) {
        return (float)this.direction.m_122430_() * this.getExtendedProgress(this.getProgress(ticks));
    }

    public float getOffsetZ(float ticks) {
        return (float)this.direction.m_122431_() * this.getExtendedProgress(this.getProgress(ticks));
    }

    private float getExtendedProgress(float progress) {
        return this.extending ? progress - 1.0f : 1.0f - progress;
    }

    private BlockState getCollisionRelatedBlockState() {
        return !this.isExtending() && this.isSourcePiston() && this.movedState.m_60734_() instanceof ReinforcedPistonBaseBlock ? (BlockState)((BlockState)((BlockState)((ReinforcedPistonHeadBlock)SCContent.REINFORCED_PISTON_HEAD.get()).m_49966_().m_61124_((Property)PistonHeadBlock.f_60236_, (Comparable)Boolean.valueOf(this.progress > 0.25f))).m_61124_((Property)PistonHeadBlock.f_60235_, (Comparable)(this.movedState.m_60713_((Block)SCContent.REINFORCED_STICKY_PISTON.get()) ? PistonType.STICKY : PistonType.DEFAULT))).m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)((Direction)this.movedState.m_61143_((Property)DirectionalBlock.f_52588_))) : this.movedState;
    }

    private static void moveCollidedEntities(Level level, BlockPos pos, float progress, ReinforcedPistonMovingBlockEntity be) {
        AABB boundingBox;
        List list;
        Direction direction = be.getMovementDirection();
        double progressChange = progress - be.progress;
        VoxelShape collisionShape = be.getCollisionRelatedBlockState().m_60812_((BlockGetter)level, pos);
        if (!collisionShape.m_83281_() && !(list = level.m_45933_(null, PistonMath.m_60328_((AABB)(boundingBox = ReinforcedPistonMovingBlockEntity.moveByPositionAndProgress(pos, collisionShape.m_83215_(), be)), (Direction)direction, (double)progressChange).m_82367_(boundingBox))).isEmpty()) {
            List boundingBoxes = collisionShape.m_83299_();
            boolean isSlimeBlock = be.movedState.isSlimeBlock();
            Iterator entities = list.iterator();
            while (true) {
                AABB entityCollision;
                AABB aabb;
                AABB movementArea;
                if (!entities.hasNext()) {
                    return;
                }
                Entity entity = (Entity)entities.next();
                if (entity.m_7752_() == PushReaction.IGNORE) continue;
                if (isSlimeBlock) {
                    if (entity instanceof ServerPlayer) continue;
                    Vec3 vec3 = entity.m_20184_();
                    double x = vec3.f_82479_;
                    double y = vec3.f_82480_;
                    double z = vec3.f_82481_;
                    switch (direction.m_122434_()) {
                        case X: {
                            x = direction.m_122429_();
                            break;
                        }
                        case Y: {
                            y = direction.m_122430_();
                            break;
                        }
                        case Z: {
                            z = direction.m_122431_();
                        }
                    }
                    entity.m_20334_(x, y, z);
                }
                double d4 = 0.0;
                Iterator iterator = boundingBoxes.iterator();
                while (!(!iterator.hasNext() || (movementArea = PistonMath.m_60328_((AABB)ReinforcedPistonMovingBlockEntity.moveByPositionAndProgress(pos, aabb = (AABB)iterator.next(), be), (Direction)direction, (double)progressChange)).m_82381_(entityCollision = entity.m_20191_()) && (d4 = Math.max(d4, ReinforcedPistonMovingBlockEntity.getMovement(movementArea, direction, entityCollision))) >= progressChange)) {
                }
                if (!(d4 > 0.0)) continue;
                d4 = Math.min(d4, progressChange) + 0.01;
                ReinforcedPistonMovingBlockEntity.moveEntityByPiston(direction, entity, d4, direction);
                if (be.extending || !be.isSourcePiston) continue;
                ReinforcedPistonMovingBlockEntity.fixEntityWithinPistonBase(pos, entity, direction, progressChange);
            }
        }
    }

    private static void moveEntityByPiston(Direction direction, Entity entity, double progress, Direction moveDirection) {
        NOCLIP.set(direction);
        entity.m_6478_(MoverType.PISTON, new Vec3(progress * (double)moveDirection.m_122429_(), progress * (double)moveDirection.m_122430_(), progress * (double)moveDirection.m_122431_()));
        NOCLIP.set(null);
    }

    private static void moveStuckEntities(Level level, BlockPos pos, float progress, ReinforcedPistonMovingBlockEntity be) {
        Direction direction;
        if (be.isStickyForEntities() && (direction = be.getMovementDirection()).m_122434_().m_122479_()) {
            double collisionShapeTop = be.movedState.m_60812_((BlockGetter)level, pos).m_83297_(Direction.Axis.Y);
            AABB aabb = ReinforcedPistonMovingBlockEntity.moveByPositionAndProgress(pos, new AABB(0.0, collisionShapeTop, 0.0, 1.0, 1.5000000999999998, 1.0), be);
            double progressChange = progress - be.progress;
            for (Entity entity2 : level.m_6249_((Entity)null, aabb, entity -> ReinforcedPistonMovingBlockEntity.matchesStickyCriteria(aabb, entity))) {
                ReinforcedPistonMovingBlockEntity.moveEntityByPiston(direction, entity2, progressChange, direction);
            }
        }
    }

    private static boolean matchesStickyCriteria(AABB shape, Entity entity) {
        return entity.m_7752_() == PushReaction.NORMAL && entity.m_20096_() && entity.m_20185_() >= shape.f_82288_ && entity.m_20185_() <= shape.f_82291_ && entity.m_20189_() >= shape.f_82290_ && entity.m_20189_() <= shape.f_82293_;
    }

    private boolean isStickyForEntities() {
        return this.movedState.m_60713_(Blocks.f_50719_);
    }

    public Direction getMovementDirection() {
        return this.extending ? this.direction : this.direction.m_122424_();
    }

    private static double getMovement(AABB headShape, Direction direction, AABB facing) {
        return switch (direction) {
            case Direction.EAST -> headShape.f_82291_ - facing.f_82288_;
            case Direction.WEST -> facing.f_82291_ - headShape.f_82288_;
            case Direction.DOWN -> facing.f_82292_ - headShape.f_82289_;
            case Direction.SOUTH -> headShape.f_82293_ - facing.f_82290_;
            case Direction.NORTH -> facing.f_82293_ - headShape.f_82290_;
            default -> headShape.f_82292_ - facing.f_82289_;
        };
    }

    private static AABB moveByPositionAndProgress(BlockPos pos, AABB boundingBox, ReinforcedPistonMovingBlockEntity be) {
        double extendedProgress = be.getExtendedProgress(be.progress);
        return boundingBox.m_82386_((double)pos.m_123341_() + extendedProgress * (double)be.direction.m_122429_(), (double)pos.m_123342_() + extendedProgress * (double)be.direction.m_122430_(), (double)pos.m_123343_() + extendedProgress * (double)be.direction.m_122431_());
    }

    private static void fixEntityWithinPistonBase(BlockPos pos, Entity entity, Direction pushDirection, double progress) {
        double d1;
        Direction direction;
        double d0;
        AABB pistonBoundingBox;
        AABB entityBoundingBox = entity.m_20191_();
        if (entityBoundingBox.m_82381_(pistonBoundingBox = Shapes.m_83144_().m_83215_().m_82338_(pos)) && Math.abs((d0 = ReinforcedPistonMovingBlockEntity.getMovement(pistonBoundingBox, direction = pushDirection.m_122424_(), entityBoundingBox) + 0.01) - (d1 = ReinforcedPistonMovingBlockEntity.getMovement(pistonBoundingBox, direction, entityBoundingBox.m_82323_(pistonBoundingBox)) + 0.01)) < 0.01) {
            d0 = Math.min(d0, progress) + 0.01;
            ReinforcedPistonMovingBlockEntity.moveEntityByPiston(pushDirection, entity, d0, direction);
        }
    }

    public BlockState getMovedState() {
        return this.movedState;
    }

    public void finalTick() {
        if (this.f_58857_ != null && (this.lastProgress < 1.0f || this.f_58857_.f_46443_)) {
            this.lastProgress = this.progress = 1.0f;
            this.f_58857_.m_46747_(this.f_58858_);
            this.m_7651_();
            if (this.f_58857_.m_8055_(this.f_58858_).m_60713_((Block)SCContent.REINFORCED_MOVING_PISTON.get())) {
                BlockState pushedState = this.isSourcePiston ? Blocks.f_50016_.m_49966_() : Block.m_49931_((BlockState)this.movedState, (LevelAccessor)this.f_58857_, (BlockPos)this.f_58858_);
                if (this.movedBlockEntityTag != null) {
                    BlockEntity be;
                    BlockEntity blockEntity = be = pushedState.m_155947_() ? ((EntityBlock)pushedState.m_60734_()).m_142194_(this.f_58858_, pushedState) : null;
                    if (be != null) {
                        be.m_142466_(this.movedBlockEntityTag);
                        this.f_58857_.m_151523_(be);
                        if (be instanceof IModuleInventory) {
                            IModuleInventory moduleInv = (IModuleInventory)be;
                            moduleInv.getInsertedModules().forEach(type -> {
                                if (moduleInv.isModuleEnabled((ModuleType)((Object)type))) {
                                    moduleInv.onModuleInserted(moduleInv.getModule((ModuleType)((Object)type)), (ModuleType)((Object)type), true);
                                } else {
                                    moduleInv.onModuleRemoved(moduleInv.getModule((ModuleType)((Object)type)), (ModuleType)((Object)type), true);
                                }
                            });
                        }
                    }
                }
                this.f_58857_.m_7731_(this.f_58858_, pushedState, 3);
                this.f_58857_.m_46586_(this.f_58858_, pushedState.m_60734_(), this.f_58858_);
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ReinforcedPistonMovingBlockEntity be) {
        be.lastTicked = level.m_46467_();
        be.lastProgress = be.progress;
        if (be.lastProgress >= 1.0f) {
            if (level.f_46443_ && be.deathTicks < 5) {
                ++be.deathTicks;
            } else {
                level.m_46747_(pos);
                be.m_7651_();
                if (be.movedState != null && level.m_8055_(pos).m_60713_((Block)SCContent.REINFORCED_MOVING_PISTON.get())) {
                    BlockState pushedState = Block.m_49931_((BlockState)be.movedState, (LevelAccessor)level, (BlockPos)pos);
                    if (pushedState.m_60795_()) {
                        level.m_7731_(pos, be.movedState, 84);
                        Block.m_49902_((BlockState)be.movedState, (BlockState)pushedState, (LevelAccessor)level, (BlockPos)pos, (int)3);
                    } else {
                        if (pushedState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)pushedState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                            pushedState = (BlockState)pushedState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
                        }
                        if (be.movedBlockEntityTag != null) {
                            BlockEntity storedBe;
                            BlockEntity blockEntity = storedBe = pushedState.m_155947_() ? ((EntityBlock)pushedState.m_60734_()).m_142194_(be.f_58858_, pushedState) : null;
                            if (storedBe != null) {
                                storedBe.m_142466_(be.movedBlockEntityTag);
                                level.m_151523_(storedBe);
                                if (storedBe instanceof IModuleInventory) {
                                    IModuleInventory moduleInv = (IModuleInventory)storedBe;
                                    moduleInv.getInsertedModules().forEach(type -> {
                                        if (moduleInv.isModuleEnabled((ModuleType)((Object)type))) {
                                            moduleInv.onModuleInserted(moduleInv.getModule((ModuleType)((Object)type)), (ModuleType)((Object)type), true);
                                        } else {
                                            moduleInv.onModuleRemoved(moduleInv.getModule((ModuleType)((Object)type)), (ModuleType)((Object)type), true);
                                        }
                                    });
                                }
                            }
                        }
                        level.m_7731_(pos, pushedState, 67);
                        level.m_46586_(pos, pushedState.m_60734_(), pos);
                    }
                }
            }
        } else {
            float f = be.progress + 0.5f;
            ReinforcedPistonMovingBlockEntity.moveCollidedEntities(level, pos, f, be);
            ReinforcedPistonMovingBlockEntity.moveStuckEntities(level, pos, f, be);
            be.progress = f;
            if (be.progress >= 1.0f) {
                be.progress = 1.0f;
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        HolderLookup.RegistryLookup holderGetter = this.f_58857_ != null ? this.f_58857_.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_();
        this.movedState = NbtUtils.m_247651_((HolderGetter)holderGetter, (CompoundTag)tag.m_128469_("blockState"));
        this.direction = Direction.m_122376_((int)tag.m_128451_("facing"));
        this.lastProgress = this.progress = tag.m_128457_("progress");
        this.extending = tag.m_128471_("extending");
        this.isSourcePiston = tag.m_128471_("source");
        this.movedBlockEntityTag = (CompoundTag)tag.m_128423_("movedBlockEntityTag");
        this.owner.load(tag);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("blockState", (Tag)NbtUtils.m_129202_((BlockState)this.movedState));
        tag.m_128405_("facing", this.direction.m_122411_());
        tag.m_128350_("progress", this.lastProgress);
        tag.m_128379_("extending", this.extending);
        tag.m_128379_("source", this.isSourcePiston);
        if (this.movedBlockEntityTag != null) {
            tag.m_128365_("movedBlockEntityTag", (Tag)this.movedBlockEntityTag);
        }
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
    }

    public VoxelShape getCollisionShape(BlockGetter level, BlockPos pos) {
        VoxelShape shape = !this.extending && this.isSourcePiston ? ((BlockState)this.movedState.m_61124_((Property)PistonBaseBlock.f_60153_, (Comparable)Boolean.valueOf(true))).m_60812_(level, pos) : Shapes.m_83040_();
        if ((double)this.progress < 1.0 && NOCLIP.get() == this.getMovementDirection()) {
            return shape;
        }
        BlockState state = this.isSourcePiston() ? (BlockState)((BlockState)((ReinforcedPistonHeadBlock)SCContent.REINFORCED_PISTON_HEAD.get()).m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)this.direction)).m_61124_((Property)PistonHeadBlock.f_60236_, (Comparable)Boolean.valueOf(this.extending != 1.0f - this.progress < 4.0f)) : this.movedState;
        float extendedProgress = this.getExtendedProgress(this.progress);
        double x = (float)this.direction.m_122429_() * extendedProgress;
        double y = (float)this.direction.m_122430_() * extendedProgress;
        double z = (float)this.direction.m_122431_() * extendedProgress;
        return Shapes.m_83110_((VoxelShape)shape, (VoxelShape)state.m_60812_(level, pos).m_83216_(x, y, z));
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.m_6596_();
    }

    public long getLastTicked() {
        return this.lastTicked;
    }
}

