/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LaserBlockMenu;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.UpdateLaserColors;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.PacketDistributor;

public class LaserBlockBlockEntity
extends LinkableBlockEntity
implements MenuProvider,
ContainerListener {
    private Option.DisabledOption disabled = new Option.DisabledOption((Boolean)false){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockBlockEntity.this.setLasersAccordingToDisabledOption();
        }
    };
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.IntOption signalLength = new Option.SignalLengthOption(50);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private Map<Direction, Boolean> sideConfig = (Map)Util.m_137537_(() -> {
        EnumMap<Direction, Boolean> map = new EnumMap<Direction, Boolean>(Direction.class);
        for (Direction dir : Direction.values()) {
            map.put(dir, true);
        }
        return map;
    });
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private LazyOptional<IItemHandler> lensHandler;
    private LensContainer lenses = new LensContainer(6);
    private long lastToggleTime;

    public LaserBlockBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get(), pos, state);
        this.lenses.m_19164_(this);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("sideConfig", (Tag)LaserBlockBlockEntity.saveSideConfig(this.sideConfig));
        for (int i = 0; i < this.lenses.m_6643_(); ++i) {
            tag.m_128365_("lens" + i, (Tag)this.lenses.m_8020_(i).m_41739_(new CompoundTag()));
        }
    }

    public static CompoundTag saveSideConfig(Map<Direction, Boolean> sideConfig) {
        CompoundTag sideConfigTag = new CompoundTag();
        sideConfig.forEach((dir, enabled) -> sideConfigTag.m_128379_(dir.m_122433_(), enabled.booleanValue()));
        return sideConfigTag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.sideConfig = LaserBlockBlockEntity.loadSideConfig(tag.m_128469_("sideConfig"));
        for (int i = 0; i < this.lenses.m_6643_(); ++i) {
            this.lenses.setItemExclusively(i, ItemStack.m_41712_((CompoundTag)tag.m_128469_("lens" + i)));
        }
        this.lenses.m_6596_();
    }

    public static Map<Direction, Boolean> loadSideConfig(CompoundTag sideConfigTag) {
        EnumMap<Direction, Boolean> sideConfig = new EnumMap<Direction, Boolean>(Direction.class);
        for (Direction dir : Direction.values()) {
            if (sideConfigTag.m_128425_(dir.m_122433_(), 1)) {
                sideConfig.put(dir, sideConfigTag.m_128471_(dir.m_122433_()));
                continue;
            }
            sideConfig.put(dir, true);
        }
        return sideConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onLinkedBlockAction(ILinkedAction action, List<LinkableBlockEntity> excludedBEs) {
        if (action instanceof ILinkedAction.OptionChanged) {
            ILinkedAction.OptionChanged optionChanged = (ILinkedAction.OptionChanged)action;
            Option option = optionChanged.option();
            if (option.getName().equals(this.disabled.getName())) {
                this.disabled.copy(option);
                this.setLasersAccordingToDisabledOption();
            } else if (option.getName().equals(this.ignoreOwner.getName())) {
                this.ignoreOwner.copy(option);
            } else if (option.getName().equals(this.signalLength.getName())) {
                this.signalLength.copy(option);
                this.turnOffRedstoneOutput();
            } else {
                if (!option.getName().equals(this.respectInvisibility.getName())) throw new UnsupportedOperationException("Unhandled option synchronization in laser block! " + option.getName());
                this.respectInvisibility.copy(option);
            }
        } else if (action instanceof ILinkedAction.ModuleInserted) {
            ILinkedAction.ModuleInserted moduleInserted = (ILinkedAction.ModuleInserted)action;
            this.insertModule(moduleInserted.stack(), moduleInserted.wasModuleToggled());
        } else if (action instanceof ILinkedAction.ModuleRemoved) {
            ILinkedAction.ModuleRemoved moduleRemoved = (ILinkedAction.ModuleRemoved)action;
            this.removeModule(moduleRemoved.moduleType(), moduleRemoved.wasModuleToggled());
        } else if (action instanceof ILinkedAction.OwnerChanged) {
            ILinkedAction.OwnerChanged ownerChanged = (ILinkedAction.OwnerChanged)action;
            Owner owner = ownerChanged.newOwner();
            this.setOwner(owner.getUUID(), owner.getName());
        } else if (action instanceof ILinkedAction.StateChanged) {
            ILinkedAction.StateChanged stateChanged = (ILinkedAction.StateChanged)action;
            BlockState state = this.m_58900_();
            if (stateChanged.property() == LaserBlock.POWERED) {
                if (this.timeSinceLastToggle() < 500L) {
                    this.setLastToggleTime(System.currentTimeMillis());
                } else {
                    int signalLength = this.getSignalLength();
                    this.setLastToggleTime(System.currentTimeMillis());
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61122_((Property)LaserBlock.POWERED));
                    BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, (Block)SCContent.LASER_BLOCK.get());
                    if (signalLength > 0) {
                        this.f_58857_.m_186460_(this.f_58858_, (Block)SCContent.LASER_BLOCK.get(), signalLength);
                    }
                }
            }
        }
        excludedBEs.add(this);
        this.propagate(action, excludedBEs);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.signalLength) {
            this.turnOffRedstoneOutput();
        }
        super.onOptionChanged(option);
    }

    private void turnOffRedstoneOutput() {
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)LaserBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, this.m_58900_().m_60734_());
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted(this, stack, toggled);
        } else if (module == ModuleType.SMART) {
            this.applyExistingSideConfig();
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved(this, stack, toggled);
        } else if (module == ModuleType.REDSTONE) {
            if (((Boolean)this.m_58900_().m_61143_((Property)LaserBlock.POWERED)).booleanValue()) {
                this.turnOffRedstoneOutput();
            }
        } else if (module == ModuleType.SMART) {
            this.applyExistingSideConfig();
        }
    }

    public void m_5757_(Container container) {
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            int i = 1;
            BlockPos pos = this.m_58899_();
            BlockPos modifiedPos = pos.m_5484_(direction, i);
            BlockState stateAtModifiedPos = this.f_58857_.m_8055_(modifiedPos);
            ArrayList<BlockPos> positionsToUpdate = new ArrayList<BlockPos>();
            while (i < (Integer)ConfigHandler.SERVER.laserBlockRange.get() && stateAtModifiedPos.m_60734_() != SCContent.LASER_BLOCK.get()) {
                modifiedPos = pos.m_5484_(direction, ++i);
                stateAtModifiedPos = this.f_58857_.m_8055_(modifiedPos);
                positionsToUpdate.add(modifiedPos);
            }
            BlockEntity blockEntity = this.f_58857_.m_7702_(modifiedPos);
            if (!(blockEntity instanceof LaserBlockBlockEntity)) continue;
            LaserBlockBlockEntity otherLaser = (LaserBlockBlockEntity)blockEntity;
            otherLaser.getLensContainer().setItemExclusively(direction.m_122424_().ordinal(), this.lenses.m_8020_(direction.ordinal()));
            if (!this.f_58857_.f_46443_) {
                SecurityCraft.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> this.f_58857_.m_46472_()), (Object)new UpdateLaserColors(positionsToUpdate));
            }
            this.f_58857_.m_7260_(modifiedPos, stateAtModifiedPos, stateAtModifiedPos, 2);
        }
        this.m_6596_();
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public void onLoad() {
        super.onLoad();
        DisguisableBlockEntity.onOnLoad(this);
    }

    @Override
    public void readOptions(CompoundTag tag) {
        if (tag.m_128441_("enabled")) {
            tag.m_128379_("disabled", !tag.m_128471_("enabled"));
        }
        for (Option<?> option : this.customOptions()) {
            option.load(tag);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return BlockUtils.isAllowedToExtractFromProtectedObject(side, this) ? this.getNormalHandler().cast() : this.getInsertOnlyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        if (this.insertOnlyHandler != null) {
            this.insertOnlyHandler.invalidate();
        }
        if (this.lensHandler != null) {
            this.lensHandler.invalidate();
        }
        super.invalidateCaps();
    }

    public void reviveCaps() {
        this.insertOnlyHandler = null;
        this.lensHandler = null;
        super.reviveCaps();
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((Container)this.lenses));
        }
        return this.insertOnlyHandler;
    }

    private LazyOptional<IItemHandler> getNormalHandler() {
        if (this.lensHandler == null) {
            this.lensHandler = LazyOptional.of(() -> new InvWrapper((Container)this.lenses));
        }
        return this.lensHandler;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new LaserBlockMenu(id, this.f_58857_, this.f_58858_, this.sideConfig, inventory);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    public LensContainer getLensContainer() {
        return this.lenses;
    }

    public void m_7651_() {
        super.m_7651_();
        DisguisableBlockEntity.onSetRemoved(this);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.ALLOWLIST, ModuleType.DISGUISE, ModuleType.REDSTONE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled, this.ignoreOwner, this.signalLength, this.respectInvisibility};
    }

    public ModelData getModelData() {
        return DisguisableBlockEntity.getModelData(this);
    }

    public boolean isEnabled() {
        return (Boolean)this.disabled.get() == false;
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isConsideredInvisible(LivingEntity entity) {
        return this.respectInvisibility.isConsideredInvisible(entity);
    }

    public void setLastToggleTime(long lastToggleTime) {
        this.lastToggleTime = lastToggleTime;
    }

    public long getLastToggleTime() {
        return this.lastToggleTime;
    }

    public long timeSinceLastToggle() {
        return System.currentTimeMillis() - this.getLastToggleTime();
    }

    public void applyNewSideConfig(Map<Direction, Boolean> sideConfig, Player player) {
        sideConfig.forEach((direction, enabled) -> this.setSideEnabled((Direction)direction, (boolean)enabled, player));
    }

    public void applyExistingSideConfig() {
        for (Direction direction : Direction.values()) {
            this.toggleLaserOnSide(direction, this.isSideEnabled(direction), null, false);
        }
    }

    public void setSideEnabled(Direction direction, boolean enabled, Player player) {
        this.sideConfig.put(direction, enabled);
        if (this.isModuleEnabled(ModuleType.SMART)) {
            this.toggleLaserOnSide(direction, enabled, player, true);
        }
    }

    public void toggleLaserOnSide(Direction direction, boolean enabled, Player player, boolean modifyOtherLaser) {
        BlockEntity blockEntity;
        int i = 1;
        BlockPos pos = this.m_58899_();
        BlockPos modifiedPos = pos.m_5484_(direction, i);
        BlockState stateAtModifiedPos = this.f_58857_.m_8055_(modifiedPos);
        while (i < (Integer)ConfigHandler.SERVER.laserBlockRange.get() && stateAtModifiedPos.m_60734_() != SCContent.LASER_BLOCK.get()) {
            modifiedPos = pos.m_5484_(direction, ++i);
            stateAtModifiedPos = this.f_58857_.m_8055_(modifiedPos);
        }
        if (modifyOtherLaser && (blockEntity = this.f_58857_.m_7702_(modifiedPos)) instanceof LaserBlockBlockEntity) {
            LaserBlockBlockEntity otherLaser = (LaserBlockBlockEntity)blockEntity;
            otherLaser.sideConfig.put(direction.m_122424_(), enabled);
        }
        if (enabled && (blockEntity = this.m_58900_().m_60734_()) instanceof LaserBlock) {
            LaserBlock block = (LaserBlock)blockEntity;
            block.setLaser(this.f_58857_, pos, direction, player);
        } else if (!enabled) {
            int boundType = LaserFieldBlock.getBoundType(direction);
            BlockUtils.removeInSequence((directionToCheck, stateToCheck) -> stateToCheck.m_60713_((Block)SCContent.LASER_FIELD.get()) && (Integer)stateToCheck.m_61143_((Property)LaserFieldBlock.BOUNDTYPE) == boundType, (LevelAccessor)this.f_58857_, this.f_58858_, direction);
        }
    }

    public Map<Direction, Boolean> getSideConfig() {
        return this.sideConfig;
    }

    public boolean isSideEnabled(Direction dir) {
        return !this.isModuleEnabled(ModuleType.SMART) || this.sideConfig.getOrDefault(dir, true) != false;
    }

    private void setLasersAccordingToDisabledOption() {
        if (this.isEnabled()) {
            ((LaserBlock)this.m_58900_().m_60734_()).setLaser(this.f_58857_, this.f_58858_, null);
        } else {
            LaserBlock.destroyAdjacentLasers((LevelAccessor)this.f_58857_, this.f_58858_);
        }
    }

    public ModuleType synchronizeWith(LaserBlockBlockEntity that) {
        if (!LinkableBlockEntity.isLinkedWith(this, that)) {
            Object2BooleanArrayMap bothInsertedModules = new Object2BooleanArrayMap();
            List thisInsertedModules = this.getInsertedModules();
            List thatInsertedModules = that.getInsertedModules();
            for (ModuleType moduleType : thisInsertedModules) {
                ItemStack thisModule = this.getModule(moduleType);
                if (thatInsertedModules.contains((Object)moduleType) && !thisModule.areShareTagsEqual(that.getModule(moduleType))) {
                    return moduleType;
                }
                bothInsertedModules.put(thisModule.m_41777_(), this.isModuleEnabled(moduleType));
                this.removeModule(moduleType, false);
            }
            for (ModuleType moduleType : thatInsertedModules) {
                bothInsertedModules.put(that.getModule(moduleType).m_41777_(), that.isModuleEnabled(moduleType));
                that.removeModule(moduleType, false);
                this.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(moduleType, false), that);
            }
            this.readOptions(that.writeOptions(new CompoundTag()));
            LinkableBlockEntity.link(this, that);
            for (Map.Entry entry : bothInsertedModules.entrySet()) {
                ItemStack module = (ItemStack)entry.getKey();
                ModuleItem item = (ModuleItem)module.m_41720_();
                ModuleType type = item.getModuleType();
                this.insertModule((ItemStack)entry.getKey(), false);
                this.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(module, item, false), this);
                this.toggleModuleState(type, (Boolean)entry.getValue());
                this.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(module, item, true), this);
            }
        }
        return null;
    }
}

